package com.jz.jar.media.proxy;

import org.apache.commons.lang3.tuple.Pair;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

import com.jz.common.utils.text.StringTools;
import com.jz.jar.franchise.service.StudentInfoService;
import com.jz.jar.media.tool.Global;
import com.jz.jooq.media.tables.pojos.Level;

/**
 * @Title StudentLevelProxy
 * @Package com.jz.jar.media.proxy
 * @author tangjunfeng
 * @date 2018年8月10日 下午12:06:04
 * @version V1.0
 */
@Lazy
@Service
public class StudentLevelProxy {

	@Autowired
	private LevelProxy levelProxy;
	@Autowired
	private StudentInfoService studentInfoService;
	
	public Level getLevelForAge(String puid, String suid) {
		if (!StringTools.allNotEmptyAndBlank(puid, suid))
			return null;
		String birthday = studentInfoService.getStudentBirthday(puid, suid);
		if (StringTools.isEmptyAndBlank(birthday))
			return null;
		Pair<Integer, Integer> yearOfMonth = Global.getAgeMonth(birthday);
		float age = yearOfMonth.getLeft() * Float.parseFloat("1." + yearOfMonth.getRight().toString());
		return levelProxy.getLevelForAge(age);
	}
	
	public String getLidForBirthday(String birthday) {
		if (StringTools.isEmptyAndBlank(birthday))
			return null;
		Pair<Integer, Integer> yearOfMonth = Global.getAgeMonth(birthday);
		float age = yearOfMonth.getLeft() * Float.parseFloat("1." + yearOfMonth.getRight().toString());
		return levelProxy.getLevelForAge(age).getLid();
	}
}
