package com.jz.jar.media.wrapper;

import com.jz.jooq.franchise.tables.pojos.StudentInfo;

public class StudentWrapper {
	private StudentWrapper() {
	}

	private String suid;
	private String name;
	private String enName;
	private String sex;
	private String age;
	private String level;
	private Integer signCnt;
	private String playTitle;

	public static StudentWrapper of(StudentInfo studentInfo) {
		return new StudentWrapper().setSuid(studentInfo.getSuid()).setName(studentInfo.getName())
				.setEnName(studentInfo.getEngName()).setSex(studentInfo.getSex());
	}

	public String getSuid() {
		return suid;
	}

	public StudentWrapper setSuid(String suid) {
		this.suid = suid;
		return this;
	}

	public String getName() {
		return name;
	}

	public StudentWrapper setName(String name) {
		this.name = name;
		return this;
	}

	public String getEnName() {
		return enName;
	}

	public StudentWrapper setEnName(String enName) {
		this.enName = enName;
		return this;
	}

	public String getSex() {
		return sex;
	}

	public StudentWrapper setSex(String sex) {
		this.sex = sex;
		return this;
	}

	public String getAge() {
		return age;
	}

	public StudentWrapper setAge(String age) {
		this.age = age;
		return this;
	}

	public String getLevel() {
		return level;
	}

	public StudentWrapper setLevel(String level) {
		this.level = level;
		return this;
	}

	public Integer getSignCnt() {
		return signCnt;
	}

	public StudentWrapper setSignCnt(Integer signCnt) {
		this.signCnt = signCnt;
		return this;
	}

	public String getPlayTitle() {
		return playTitle;
	}

	public StudentWrapper setPlayTitle(String playTitle) {
		this.playTitle = playTitle;
		return this;
	}

}
