/*
 * Decompiled with CFR 0.152.
 */
package com.jz.jar.media.proxy;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.jz.common.utils.collection.ArrayMapTools;
import com.jz.common.utils.text.StringTools;
import com.jz.jar.media.common.ItemCard;
import com.jz.jar.media.proxy.PlaylistVideoProxy;
import com.jz.jar.media.request.NextPlayVideoRequest;
import com.jz.jar.media.request.PlaylistRequest;
import com.jz.jar.media.service.PlaylistService;
import com.jz.jar.media.service.UserCollectService;
import com.jz.jar.media.tool.AliyunBean;
import com.jz.jar.media.wrapper.PlaylistWrapper;
import com.jz.jooq.media.tables.pojos.Playlist;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

@Lazy
@Service
public class PlaylistProxy {
    @Autowired
    private PlaylistService playlistService;
    @Autowired
    private UserCollectService userCollectService;
    @Autowired
    private PlaylistVideoProxy playlistVideoProxy;

    public PlaylistWrapper getSinglePlaylist(PlaylistRequest req) {
        Playlist pl = this.playlistService.getPlaylist(req.getPid());
        if (null == pl) {
            return null;
        }
        PlaylistWrapper wp = PlaylistWrapper.of(pl).setPic(AliyunBean.getScreenshotUrl(pl.getPic()));
        boolean isCollect = false;
        if (StringTools.isNotEmptyAndBlank((String)req.getUid())) {
            isCollect = this.userCollectService.isCollect(req.getUid(), req.getPid());
        }
        wp.setIsCollect(isCollect);
        if (req.getWithNextVideo().booleanValue()) {
            wp.setVideo(this.playlistVideoProxy.getNextPlayVideoForHistory(req.getUid(), pl));
        }
        return wp;
    }

    public List<ItemCard> getMultiPlaylist(PlaylistRequest req) {
        List playlistArray = this.playlistService.getPlaylist(req.getPids());
        if (ArrayMapTools.isEmpty((Collection)playlistArray)) {
            return null;
        }
        List collectPlaylist = null;
        if (null == req.getIsCollect() && StringTools.isNotEmptyAndBlank((String)req.getUid())) {
            collectPlaylist = this.userCollectService.getExistCollect(req.getUid(), req.getPids());
        }
        if (null == collectPlaylist) {
            collectPlaylist = Lists.newArrayList();
        }
        Map<Object, Object> pid2VideoCard = null;
        if (req.getWithNextVideo().booleanValue()) {
            NextPlayVideoRequest nextRequest = NextPlayVideoRequest.of(req.getUid(), req.getSuid(), playlistArray);
            nextRequest.setIsSpecial(req.getIsSpecial()).setIsEverday(req.getIsEverday());
            pid2VideoCard = this.playlistVideoProxy.getNextPlayVideoForHistory(nextRequest);
        } else {
            pid2VideoCard = Maps.newHashMap();
        }
        ArrayList cards = Lists.newArrayList();
        PlaylistWrapper wp = null;
        for (Playlist pl : playlistArray) {
            wp = PlaylistWrapper.of(pl).setPic(AliyunBean.getScreenshotUrl(pl.getPic()));
            wp.setIsCollect(null != req.getIsCollect() ? req.getIsCollect().booleanValue() : collectPlaylist.contains(pl.getPid()));
            if (null != req.getIsRecomm()) {
                wp.setIsRecomm(req.getIsRecomm());
            }
            wp.setVideo((ItemCard)pid2VideoCard.get(pl.getPid()));
            cards.add(ItemCard.of(wp));
        }
        return cards;
    }
}

