/*
 * Decompiled with CFR 0.152.
 */
package com.jz.jar.media.proxy;

import com.google.common.collect.Lists;
import com.jz.common.utils.collection.ArrayMapTools;
import com.jz.jar.franchise.service.StudentInfoService;
import com.jz.jar.media.proxy.PlayTitleProxy;
import com.jz.jar.media.proxy.StudentLevelProxy;
import com.jz.jar.media.tool.Global;
import com.jz.jar.media.wrapper.StudentWrapper;
import com.jz.jooq.franchise.tables.pojos.StudentInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang3.tuple.Pair;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

@Lazy
@Service
public class StudentInfoProxy {
    @Autowired
    private StudentInfoService studentInfoService;
    @Autowired
    private PlayTitleProxy playTitleProxy;
    @Autowired
    private StudentLevelProxy studentLevelProxy;

    public List<StudentWrapper> getStudents(String puid) {
        List students = this.studentInfoService.getStudents(puid);
        if (ArrayMapTools.isEmpty((Collection)students)) {
            return null;
        }
        ArrayList wrappers = Lists.newArrayList();
        for (StudentInfo st : students) {
            wrappers.add(StudentWrapper.of(st).setAge(this.getShowStudentAge(st)).setLevel(this.studentLevelProxy.getLidForBirthday(st.getBirthday())).setPlayTitle(this.playTitleProxy.getTitle(puid, st.getSuid())));
        }
        return wrappers;
    }

    public StudentWrapper getStudent(String puid, String suid) {
        StudentInfo st = this.studentInfoService.getStudent(suid);
        if (null == st) {
            return null;
        }
        return StudentWrapper.of(st).setAge(this.getShowStudentAge(st)).setLevel(this.studentLevelProxy.getLidForBirthday(st.getBirthday())).setPlayTitle(this.playTitleProxy.getTitle(puid, st.getSuid()));
    }

    private String getShowStudentAge(StudentInfo studentInfo) {
        Pair<Integer, Integer> yearOfMonth = Global.getAgeMonth(studentInfo.getBirthday());
        StringBuffer sb = new StringBuffer().append(StudentInfoProxy.getAgeContent((Integer)yearOfMonth.getLeft(), "\u5c81"));
        sb.append(StudentInfoProxy.getAgeContent((Integer)yearOfMonth.getRight(), "\u4e2a\u6708"));
        return sb.toString();
    }

    private static String getAgeContent(int num, String content) {
        return num < 0 ? "" : num + content;
    }
}

