/*
 * Decompiled with CFR 0.152.
 */
package com.jz.jar.media.proxy;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.Maps;
import com.jz.common.utils.collection.ArrayMapTools;
import com.jz.jar.media.common.ItemCard;
import com.jz.jar.media.enums.DbField;
import com.jz.jar.media.proxy.VideoProxy;
import com.jz.jar.media.request.NextPlayVideoRequest;
import com.jz.jar.media.service.CommonPlayHistoryService;
import com.jz.jar.media.service.PlaylistVideoService;
import com.jz.jar.media.service.UserPlayHistoryService;
import com.jz.jooq.media.tables.pojos.CommonPlayHistory;
import com.jz.jooq.media.tables.pojos.Playlist;
import com.jz.jooq.media.tables.pojos.UserPlayHistory;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

@Lazy
@Service
public class PlaylistVideoProxy {
    @Autowired
    private UserPlayHistoryService userPlayHistoryService;
    @Autowired
    private PlaylistVideoService playlistVideoService;
    @Autowired
    private CommonPlayHistoryService commonPlayHistoryService;
    @Autowired
    private VideoProxy videoProxy;

    public String getNextPlayVideo(String pid, String wid) {
        List wids = this.playlistVideoService.findWids(pid);
        if (ArrayMapTools.isEmpty((Collection)wids) || !wids.contains(wid)) {
            return wid;
        }
        String lastWid = (String)wids.get(wids.size() - 1);
        if (lastWid.equals(wid)) {
            return (String)wids.get(0);
        }
        for (int i = 0; i < wids.size(); ++i) {
            if (!wid.equals(wids.get(i))) continue;
            return (String)wids.get(i + 1);
        }
        return wid;
    }

    public ItemCard getNextPlayVideoForHistory(String uid, Playlist playlist) {
        ItemCard videoCard;
        UserPlayHistory history;
        int playlength = 0;
        String nextWid = playlist.getWid();
        if (null != uid && null != (history = this.userPlayHistoryService.getHistory(uid, playlist.getPid()))) {
            playlength = history.getPlayLength();
            nextWid = history.getNextWid();
        }
        if (null != (videoCard = this.videoProxy.getVideoCard(uid, playlist.getPid(), nextWid))) {
            videoCard.getVideo().setPlayLength(playlength);
        }
        return videoCard;
    }

    public Map<String, ItemCard> getNextPlayVideoForHistory(NextPlayVideoRequest request) {
        List histories;
        HashBiMap pid2Wid = HashBiMap.create();
        Set pids = request.getPlaylist().stream().map(it -> it.getPid()).collect(Collectors.toSet());
        if (null != request.getSuid()) {
            String commonKey;
            List playHistories;
            DbField field = null;
            if (request.getIsSpecial().booleanValue()) {
                field = DbField.special;
            } else if (request.getIsEverday().booleanValue()) {
                field = DbField.everday;
            }
            if (null != field && ArrayMapTools.isNotEmpty((Collection)(playHistories = this.commonPlayHistoryService.findPlayHistories(commonKey = this.commonPlayHistoryService.getCommonKey(request.getSuid(), field), pids)))) {
                playHistories.forEach(arg_0 -> PlaylistVideoProxy.lambda$getNextPlayVideoForHistory$1((BiMap)pid2Wid, arg_0));
                pids.removeAll(pid2Wid.keySet());
            }
        }
        HashMap wid2Playlength = Maps.newHashMap();
        if (!pids.isEmpty() && null != request.getUid() && ArrayMapTools.isNotEmpty((Collection)(histories = this.userPlayHistoryService.getHistories(request.getUid(), pids)))) {
            histories.forEach(arg_0 -> PlaylistVideoProxy.lambda$getNextPlayVideoForHistory$2((BiMap)pid2Wid, wid2Playlength, arg_0));
            pids.removeAll(pid2Wid.keySet());
        }
        if (!pids.isEmpty()) {
            request.getPlaylist().forEach(arg_0 -> PlaylistVideoProxy.lambda$getNextPlayVideoForHistory$3(pids, (BiMap)pid2Wid, arg_0));
        }
        HashMap pid2VideoCard = Maps.newHashMap();
        List<ItemCard> videoCard = this.videoProxy.getVideoCards(request.getUid(), (Map<String, String>)pid2Wid.inverse());
        if (ArrayMapTools.isNotEmpty(videoCard)) {
            for (ItemCard it2 : videoCard) {
                pid2VideoCard.put(it2.getVideo().getPid(), it2);
                if (wid2Playlength.containsKey(it2.getVideo().getWid())) {
                    it2.getVideo().setPlayLength((Integer)wid2Playlength.get(it2.getVideo().getWid()));
                    continue;
                }
                it2.getVideo().setPlayLength(0);
            }
        }
        return pid2VideoCard;
    }

    private static /* synthetic */ void lambda$getNextPlayVideoForHistory$3(Set pids, BiMap pid2Wid, Playlist it) {
        if (pids.contains(it.getPid())) {
            pid2Wid.put((Object)it.getPid(), (Object)it.getWid());
        }
    }

    private static /* synthetic */ void lambda$getNextPlayVideoForHistory$2(BiMap pid2Wid, Map wid2Playlength, UserPlayHistory it) {
        pid2Wid.put((Object)it.getPid(), (Object)it.getNextWid());
        wid2Playlength.put(it.getNextWid(), it.getPlayLength());
    }

    private static /* synthetic */ void lambda$getNextPlayVideoForHistory$1(BiMap pid2Wid, CommonPlayHistory it) {
        String cfr_ignored_0 = (String)pid2Wid.put((Object)it.getPid(), (Object)it.getWid());
    }
}

