package com.jz.jar.media.proxy;

import java.util.Collection;
import java.util.List;
import java.util.Map;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

import com.google.common.collect.Lists;
import com.jz.common.utils.collection.ArrayMapTools;
import com.jz.common.utils.text.StringTools;
import com.jz.jar.media.common.ItemCard;
import com.jz.jar.media.request.NextPlayVideoRequest;
import com.jz.jar.media.request.PlaylistRequest;
import com.jz.jar.media.service.PlaylistService;
import com.jz.jar.media.service.UserCollectService;
import com.jz.jar.media.tool.AliyunBean;
import com.jz.jar.media.wrapper.PlaylistWrapper;
import com.jz.jooq.media.tables.pojos.Playlist;

@Lazy
@Service
public class PlaylistProxy {

	@Autowired
	private PlaylistService playlistService;
	@Autowired
	private UserCollectService userCollectService;
	@Autowired
	private PlaylistVideoProxy playlistVideoProxy;

	public PlaylistWrapper getSinglePlaylist(String uid, String pid) {
		return this.getSinglePlaylist(PlaylistRequest.of(uid, pid));
	}

	public PlaylistWrapper getSinglePlaylist(PlaylistRequest req) {
		Playlist pl = playlistService.getPlaylist(req.getPid());
		if (null == pl)
			return null;
		PlaylistWrapper wp = PlaylistWrapper.of(pl).setPic(AliyunBean.getScreenshotUrl(pl.getPic()));
		boolean isCollect = false;
		// 用户收藏
		if (StringTools.isNotEmptyAndBlank(req.getUid())) {
			isCollect = userCollectService.isCollect(req.getUid(), req.getPid());
		}
		wp.setIsCollect(isCollect);
		// 获取下一个需要播放的视频
		wp.setVideo(playlistVideoProxy.getNextPlayVideoForHistory(req.getUid(), pl));
		return wp;
	}

	public List<ItemCard> getMultiPlaylist(String uid, Collection<String> pids) {
		return this.getMultiPlaylist(PlaylistRequest.of(uid, pids));
	}

	public List<ItemCard> getMultiPlaylist(String uid, Collection<String> pids, boolean isRecomm) {
		return this.getMultiPlaylist(PlaylistRequest.of(uid, pids, isRecomm));
	}

	public List<ItemCard> getMultiPlaylist(String uid, Collection<String> pids, boolean isRecomm, boolean isCollect) {
		return this.getMultiPlaylist(PlaylistRequest.of(uid, pids, isRecomm, isCollect));
	}

	public List<ItemCard> getMultiPlaylist(PlaylistRequest req) {
		List<Playlist> playlistArray = playlistService.getPlaylist(req.getPids());
		if (ArrayMapTools.isEmpty(playlistArray))
			return null;
		List<String> collectPlaylist = null;
		if (null == req.getIsCollect() && StringTools.isNotEmptyAndBlank(req.getUid())) { // 获取已经收藏的专辑
			collectPlaylist = userCollectService.getExistCollect(req.getUid(), req.getPids());
		}
		if (null == collectPlaylist)
			collectPlaylist = Lists.newArrayList();
		
		// 下一个需要播放的视频
		NextPlayVideoRequest nextRequest = NextPlayVideoRequest.of(req.getUid(), req.getSuid(), playlistArray);
		nextRequest.setIsSpecial(req.getIsSpecial()).setIsEverday(req.getIsEverday());
		Map<String, ItemCard> pid2VideoCard = playlistVideoProxy.getNextPlayVideoForHistory(nextRequest);

		List<ItemCard> cards = Lists.newArrayList();
		PlaylistWrapper wp = null;
		for (Playlist pl : playlistArray) {
			wp = PlaylistWrapper.of(pl).setPic(AliyunBean.getScreenshotUrl(pl.getPic()));
			wp.setIsCollect(null != req.getIsCollect() ? req.getIsCollect() : collectPlaylist.contains(pl.getPid()));
			if (null != req.getIsRecomm()) {
				wp.setIsRecomm(req.getIsRecomm());
			}
			wp.setVideo(pid2VideoCard.get(pl.getPid()));
			cards.add(ItemCard.of(wp));
		}
		return cards;
	}

}
