package com.jz.jar.media.proxy;

import java.util.List;

import org.apache.commons.lang3.tuple.Triple;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

import com.google.common.collect.Lists;
import com.jz.jar.media.service.UserSignService;

/**
 * @Title PlayTitleProxy
 * @Package com.jz.jar.media.proxy
 * @author tangjunfeng
 * @date 2018年8月2日 下午5:17:21
 * @version V1.0
 */
@Lazy
@Service
public class PlayTitleProxy {

	private static final List<Triple<Integer, Integer, String>> titleConfig = Lists.newArrayList();

	@Autowired
	private UserSignService userSignService;

	static {
		titleConfig.add(Triple.of(0, 29, "小小体验官"));
		titleConfig.add(Triple.of(30, 49, "英语小标兵"));
		titleConfig.add(Triple.of(50, 99, "天才小博士"));
		titleConfig.add(Triple.of(100, 130, "英语小专家"));
		titleConfig.add(Triple.of(130, Integer.MAX_VALUE, "天才发明家"));
	}

	/** 获取用户称号 */
	public String getTitle(String uid, String suid) {
		int signDays = userSignService.countDays(uid, suid);
		for (Triple<Integer, Integer, String> triple : titleConfig) {
			if (triple.getLeft() <= signDays && signDays <= triple.getMiddle()) {
				return triple.getRight();
			}
		}
		return titleConfig.get(0).getRight();
	}

}
