/*
 * Decompiled with CFR 0.152.
 */
package com.jz.jar.media.proxy;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.jz.common.utils.collection.ArrayMapTools;
import com.jz.common.utils.text.StringTools;
import com.jz.jar.media.proxy.StudentLevelProxy;
import com.jz.jar.media.proxy.TopicProxy;
import com.jz.jar.media.service.DayPlaySettingService;
import com.jz.jar.media.service.MonthPlaySettingService;
import com.jz.jar.media.service.PlaylistRelationService;
import com.jz.jar.media.service.StudentDayPlayService;
import com.jz.jar.media.service.StudentMonthPlayService;
import com.jz.jar.media.wrapper.StudentMonthPlayWrapper;
import com.jz.jooq.media.tables.pojos.Level;
import com.jz.jooq.media.tables.pojos.MonthPlaySetting;
import com.jz.jooq.media.tables.pojos.Topic;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

@Lazy
@Service
public class StudentPlayProxy {
    private static final SimpleDateFormat yearMonth = new SimpleDateFormat("yyyyMM");
    private static final SimpleDateFormat yearMonthDay = new SimpleDateFormat("yyyyMMDD");
    @Autowired
    private MonthPlaySettingService monthPlaySettingService;
    @Autowired
    private StudentMonthPlayService studentMonthPlayService;
    @Autowired
    private PlaylistRelationService playlistRelationService;
    @Autowired
    private DayPlaySettingService dayPlaySettingService;
    @Autowired
    private StudentDayPlayService studentDayPlayService;
    @Autowired
    private StudentLevelProxy studentLevelProxy;
    @Autowired
    private TopicProxy topicProxy;

    public List<MonthPlaySetting> getStudentMonthPlaySetting(Level level) {
        if (null == level) {
            return null;
        }
        return this.monthPlaySettingService.findSettingForLid(level.getLid());
    }

    public List<MonthPlaySetting> getStudentMonthPlaySetting(String uid, String suid) {
        return this.getStudentMonthPlaySetting(this.studentLevelProxy.getLevelForAge(uid, suid));
    }

    public String getMonth() {
        return Calendar.getInstance().get(2) + 1 + "\u6708";
    }

    public List<StudentMonthPlayWrapper> getStudentPlayInfo(String uid, String suid) {
        return this.getStudentPlayInfo(uid, suid, this.getStudentMonthPlaySetting(uid, suid));
    }

    public List<StudentMonthPlayWrapper> getStudentPlayInfo(String uid, String suid, List<MonthPlaySetting> settings) {
        ArrayList tids;
        HashMap playCid2Minutes = Maps.newHashMap();
        HashMap taskCid2Minutes = Maps.newHashMap();
        if (ArrayMapTools.isEmpty(settings)) {
            taskCid2Minutes.putAll(this.topicProxy.getTopics().stream().collect(Collectors.toMap(it -> it.getCid(), it -> 0)));
        } else {
            taskCid2Minutes.putAll(settings.stream().collect(Collectors.toMap(it -> it.getCid(), it -> it.getMinutes())));
        }
        String currentMonth = yearMonth.format(Calendar.getInstance().getTime());
        String tempUid = StringTools.ternary((String)suid, (String)uid);
        List plays = this.studentMonthPlayService.getStudentPlayForMonth(currentMonth, tempUid);
        if (ArrayMapTools.isNotEmpty((Collection)plays)) {
            playCid2Minutes.putAll(plays.stream().collect(Collectors.toMap(it -> it.getCid(), it -> it.getSeconds() / 60)));
        }
        if ((tids = Lists.newArrayList(taskCid2Minutes.keySet())).isEmpty()) {
            tids.addAll(playCid2Minutes.keySet());
        }
        ArrayList wrappers = Lists.newArrayList();
        for (Topic tc : this.topicProxy.getTopics(tids)) {
            wrappers.add(StudentMonthPlayWrapper.of(tc.getName()).setTaskMinutes(ArrayMapTools.getInteger((Map)taskCid2Minutes, (Object)tc.getCid())).setPlayMinutes(ArrayMapTools.getInteger((Map)playCid2Minutes, (Object)tc.getCid(), (Integer)0)));
        }
        return wrappers;
    }

    public void saveStudentMonthPlay(String puid, String suid, String pid, int seconds, Level level) {
        List topics = null;
        List<MonthPlaySetting> setting = this.getStudentMonthPlaySetting(level);
        topics = ArrayMapTools.isNotEmpty(setting) ? setting.stream().map(it -> it.getCid()).collect(Collectors.toList()) : this.playlistRelationService.getTopicsForPlaylist(pid);
        if (ArrayMapTools.isEmpty((Collection)topics)) {
            return;
        }
        String currentMonth = yearMonth.format(Calendar.getInstance().getTime());
        this.studentMonthPlayService.saveMonthPlay(currentMonth, StringTools.ternary((String)suid, (String)puid), seconds, topics);
    }

    public List<String> getTodayTaskPlaylist(String lid) {
        String today = yearMonthDay.format(Calendar.getInstance().getTime());
        return this.dayPlaySettingService.getTodayTaskPlaylist(today, lid);
    }

    public boolean isTodayTaskPlaylist(String lid, String pid) {
        String today = yearMonthDay.format(Calendar.getInstance().getTime());
        return this.dayPlaySettingService.isTodayTaskPlaylist(today, lid, pid);
    }

    public void saveStudentTodayPlay(String suid, String pid, int targetCnt, int playCnt) {
        String today = yearMonthDay.format(Calendar.getInstance().getTime());
        this.studentDayPlayService.saveTodayPlay(today, suid, pid, targetCnt, playCnt);
    }

    public List<String> getTodayCompletePlaylist(String suid, Collection<String> pids) {
        String today = yearMonthDay.format(Calendar.getInstance().getTime());
        return this.studentDayPlayService.getTodayCompletePlaylist(today, suid, pids);
    }
}

