package com.jz.jar.media.proxy;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

import com.jz.common.utils.text.StringTools;
import com.jz.jar.media.service.PlaylistRelationService;
import com.jz.jar.media.service.SpecialPracticeHistoryService;
import com.jz.jooq.media.tables.pojos.Level;
import com.jz.jooq.media.tables.pojos.Playlist;
import com.jz.jooq.media.tables.pojos.Video;

/**
 * @Title PlayTaskProxy
 * @Package com.jz.jar.media.proxy
 * @author tangjunfeng
 * @date 2018年8月14日 下午3:28:47
 * @version V1.0
 */
@Lazy
@Service
public class PlayTaskProxy {

	@Autowired
	private PlaylistRelationService playlistRelationService;
	@Autowired
	private SpecialPracticeHistoryService specialPracticeHistoryService;
	@Autowired
	private StudentLevelProxy studentLevelProxy;
	@Autowired
	private StudentPlayProxy studentPlayProxy;

	public void completePlayTask(String uid, String suid, Playlist playlist, Video video, int playLength,
			String nextWid) {
		// 获取当前用户所属的级别
		Level level = studentLevelProxy.getLevelForAge(uid, suid);
		if (null == level)
			return;
		// 月观看任务
		this.monthPlayTask(uid, suid, playlist, video, playLength, level);
		// 专项练习播放任务
		this.specialPracticePlayTask(suid, playlist, level, playLength, nextWid);
		// 日观看任务
		this.todayPlayTask(suid, level, playlist, playLength);
	}

	/** 月观看任务 */
	private void monthPlayTask(String uid, String suid, Playlist playlist, Video video, int playLength, Level level) {
		int seconds = playLength == -1 ? video.getDuration() : playLength;
		studentPlayProxy.saveStudentMonthPlay(uid, suid, playlist.getPid(), seconds, level);
	}

	/** 专项练习播放任务 */
	private void specialPracticePlayTask(String suid, Playlist playlist, Level level, int playLength, String nextWid) {
		if (StringTools.isEmptyAndBlank(suid) || playLength != -1)
			return;
		// 非专项练习
		if (!playlistRelationService.isSpecialPlaylist(level.getLid(), playlist.getPid()))
			return;
		// 保存专项练习历史
		specialPracticeHistoryService.saveHistory(suid, playlist.getPid(), playlist.getVideoCnt(), 1, nextWid);
	}
	
	/** 每日任务 */
	private void todayPlayTask(String suid, Level level, Playlist playlist, int playLength) {
		if (StringTools.isEmptyAndBlank(suid) || playLength != -1)
			return;
		// 非今日任务
		if (!studentPlayProxy.isTodayTaskPlaylist(level.getLid(), playlist.getPid()))
			return;
		// 保存每日任务
		studentPlayProxy.saveStudentTodayPlay(suid, playlist.getPid(), playlist.getVideoCnt(), 1);
	}
}
