/*
 * Decompiled with CFR 0.152.
 */
package com.jz.jar.media.proxy;

import com.google.common.collect.Maps;
import com.jz.common.utils.collection.ArrayMapTools;
import com.jz.jar.media.common.ItemCard;
import com.jz.jar.media.proxy.VideoProxy;
import com.jz.jar.media.service.PlaylistVideoService;
import com.jz.jar.media.service.UserPlayHistoryService;
import com.jz.jooq.media.tables.pojos.Playlist;
import com.jz.jooq.media.tables.pojos.UserPlayHistory;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

@Lazy
@Service
public class PlaylistVideoProxy {
    @Autowired
    private UserPlayHistoryService userPlayHistoryService;
    @Autowired
    private PlaylistVideoService playlistVideoService;
    @Autowired
    private VideoProxy videoProxy;

    public String getNextPlayVideo(String pid, String wid) {
        List wids = this.playlistVideoService.findWids(pid);
        if (ArrayMapTools.isEmpty((Collection)wids) || !wids.contains(wid)) {
            return wid;
        }
        String lastWid = (String)wids.get(wids.size() - 1);
        if (lastWid.equals(wid)) {
            return (String)wids.get(0);
        }
        for (int i = 0; i < wids.size(); ++i) {
            if (!wid.equals(wids.get(i))) continue;
            return (String)wids.get(i + 1);
        }
        return wid;
    }

    public ItemCard getNextPlayVideoForHistory(String uid, Playlist playlist) {
        ItemCard videoCard;
        UserPlayHistory history;
        int playlength = 0;
        String nextWid = playlist.getWid();
        if (null != uid && null != (history = this.userPlayHistoryService.getHistory(uid, playlist.getPid()))) {
            playlength = history.getPlayLength();
            nextWid = history.getNextWid();
        }
        if (null != (videoCard = this.videoProxy.getVideoCard(uid, playlist.getPid(), nextWid))) {
            videoCard.getVideo().setPlayLength(playlength);
        }
        return videoCard;
    }

    public Map<String, ItemCard> getNextPlayVideoForHistory(String uid, Collection<Playlist> playlistArray) {
        List pids;
        List histories;
        Map<String, String> wid2Pids = playlistArray.stream().collect(Collectors.toMap(it -> it.getWid(), it -> it.getPid()));
        HashMap wid2Playlength = Maps.newHashMap();
        if (null != uid && ArrayMapTools.isNotEmpty((Collection)(histories = this.userPlayHistoryService.getHistories(uid, pids = playlistArray.stream().map(it -> it.getPid()).collect(Collectors.toList()))))) {
            histories.forEach(it -> {
                wid2Pids.put(it.getNextWid(), it.getPid());
                wid2Playlength.put(it.getNextWid(), it.getPlayLength());
            });
        }
        HashMap pid2VideoCard = Maps.newHashMap();
        List<ItemCard> videoCard = this.videoProxy.getVideoCards(uid, wid2Pids);
        if (ArrayMapTools.isNotEmpty(videoCard)) {
            for (ItemCard it2 : videoCard) {
                pid2VideoCard.put(it2.getVideo().getPid(), it2);
                if (wid2Playlength.containsKey(it2.getVideo().getWid())) {
                    it2.getVideo().setPlayLength((Integer)wid2Playlength.get(it2.getVideo().getWid()));
                    continue;
                }
                it2.getVideo().setPlayLength(0);
            }
        }
        return pid2VideoCard;
    }
}

