/*
 * Decompiled with CFR 0.152.
 */
package com.jz.jar.media.proxy;

import com.google.common.collect.Lists;
import com.jz.aliyun.beans.AliyunConfig;
import com.jz.aliyun.tools.OssTools;
import com.jz.common.utils.collection.ArrayMapTools;
import com.jz.common.utils.text.StringTools;
import com.jz.jar.media.common.ItemCard;
import com.jz.jar.media.service.MediaVideoService;
import com.jz.jar.media.tool.AliyunBean;
import com.jz.jar.media.wrapper.VideoWrapper;
import com.jz.jooq.media.tables.pojos.Video;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

@Lazy
@Service
public class VideoProxy {
    @Autowired
    private MediaVideoService mediaVideoService;

    private String getSnapshotName(int cnt) {
        return (cnt < 10 ? "0000" : "000") + cnt;
    }

    private void getSnapshotUrl(String uid, Video video, VideoWrapper wrapper) {
        int cnt = 1;
        if (StringTools.isNotEmptyAndBlank((String)uid)) {
            cnt = uid.hashCode() % video.getSnapshotCnt();
        }
        String tempUrl = video.getSnapshotUrl().replace("{Count}", this.getSnapshotName(cnt));
        wrapper.setSnapshotUrl(AliyunBean.getScreenshotUrl(tempUrl));
    }

    private void getVideoUrl(String uid, Video video, VideoWrapper wrapper) {
        AliyunConfig aliyunConfig = AliyunBean.getMediaAliyunConfig();
        ArrayList urls = Lists.newArrayList((Object[])new String[]{video.getHd(), video.getNormal(), video.getNormal(), video.getAudit()});
        Map key2Url = OssTools.getInstance((AliyunConfig)aliyunConfig).getUrl((Collection)urls, 3600);
        wrapper.setHd((String)key2Url.get(video.getHd()));
        wrapper.setNormal((String)key2Url.get(video.getNormal()));
        wrapper.setLow((String)key2Url.get(video.getLow()));
        wrapper.setAudit((String)key2Url.get(video.getAudit()));
    }

    public ItemCard getVideoCard(String uid, String pid, String wid) {
        VideoWrapper wrapper = this.getVideoInfo(uid, pid, wid);
        if (null == wrapper) {
            return null;
        }
        return ItemCard.of(wrapper);
    }

    public VideoWrapper getVideoInfo(String uid, String pid, String wid) {
        Video video = this.mediaVideoService.getVideo(wid);
        if (null == video) {
            return null;
        }
        return this.getVideoWrapper(uid, pid, video);
    }

    public List<ItemCard> getVideoCards(String uid, String pid, Collection<String> wids) {
        List<VideoWrapper> videos = this.getVideoInfo(uid, pid, wids);
        if (ArrayMapTools.isEmpty(videos)) {
            return null;
        }
        return videos.stream().map(ItemCard::of).collect(Collectors.toList());
    }

    public List<VideoWrapper> getVideoInfo(String uid, String pid, Collection<String> wids) {
        List videos = this.mediaVideoService.findVideos(wids);
        if (ArrayMapTools.isEmpty((Collection)videos)) {
            return null;
        }
        ArrayList wrappers = Lists.newArrayList();
        for (Video it : videos) {
            wrappers.add(this.getVideoWrapper(uid, pid, it));
        }
        return wrappers;
    }

    public List<ItemCard> getVideoCards(String uid, Map<String, String> wid2Pids) {
        List<VideoWrapper> videos = this.getVideoInfo(uid, wid2Pids);
        if (ArrayMapTools.isEmpty(videos)) {
            return null;
        }
        return videos.stream().map(ItemCard::of).collect(Collectors.toList());
    }

    public List<VideoWrapper> getVideoInfo(String uid, Map<String, String> wid2Pids) {
        List videos = this.mediaVideoService.findVideos(wid2Pids.keySet());
        if (ArrayMapTools.isEmpty((Collection)videos)) {
            return null;
        }
        ArrayList wrappers = Lists.newArrayList();
        for (Video it : videos) {
            wrappers.add(this.getVideoWrapper(uid, wid2Pids.get(it.getWid()), it));
        }
        return wrappers;
    }

    private VideoWrapper getVideoWrapper(String uid, String pid, Video video) {
        VideoWrapper result = VideoWrapper.of(video).setPid(pid);
        this.getVideoUrl(uid, video, result);
        this.getSnapshotUrl(uid, video, result);
        return result;
    }
}

