package com.jz.jar.media.proxy;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

import com.google.common.collect.Lists;
import com.jz.common.utils.collection.ArrayMapTools;
import com.jz.common.utils.text.StringTools;
import com.jz.jar.franchise.service.StudentInfoService;
import com.jz.jar.media.tool.Global;
import com.jz.jar.media.wrapper.StudentWrapper;
import com.jz.jooq.franchise.tables.pojos.StudentInfo;

/**
 * @Title StudentInfoProxy
 * @Package com.jz.jar.media.proxy
 * @author tangjunfeng
 * @date 2018年8月8日 下午3:11:23
 * @version V1.0
 */
@Lazy
@Service
public class StudentInfoProxy {

	@Autowired
	private StudentInfoService studentInfoService;
	@Autowired
	private PlayTitleProxy playTitleProxy;

	/** 获取用户下的所有学员 */
	public List<StudentWrapper> getStudents(String puid) {
		List<StudentInfo> students = studentInfoService.getStudents(puid);
		if (ArrayMapTools.isEmpty(students))
			return null;
		List<StudentWrapper> wrappers = Lists.newArrayList();
		for (StudentInfo st : students) {
			wrappers.add(StudentWrapper.of(st).setAge(getStudentAge(st))
					.setPlayTitle(playTitleProxy.getTitle(puid, st.getSuid())));
		}
		return wrappers;
	}
	
	/** 获取用户下的所有学员 */
	public StudentWrapper getStudent(String puid, String suid) {
		StudentInfo st = studentInfoService.getStudent(suid);
		if (null == st)
			return null;
		return StudentWrapper.of(st).setAge(getStudentAge(st))
				.setPlayTitle(playTitleProxy.getTitle(puid, st.getSuid()));
	}
	
	/** 获取学员的年龄 */
	private int getStudentAge(StudentInfo studentInfo) {
		int tempAge = Global.getAge(studentInfo.getBirthday()).intValue();
		return tempAge < 0 ? 0 : tempAge;
	}
	
	/** 获取学员的年龄 */
	public double getStudentAge(String puid, String suid) {
		String birthday = studentInfoService.getStudentBirthday(puid, suid);
		if (StringTools.isEmptyAndBlank(birthday))
			return 0;
		return Global.getAge(birthday);
	}
}
