/*
 * Decompiled with CFR 0.152.
 */
package com.jz.jar.media.cache;

import com.google.common.collect.Maps;
import com.jz.common.utils.collection.ArrayMapTools;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;
import redis.clients.jedis.JedisCluster;
import redis.clients.jedis.Tuple;

@Lazy
@Component
public class SpecialPracticeCache {
    private static final Logger logger = LoggerFactory.getLogger(SpecialPracticeCache.class);
    private static final int seconds = 3600;
    private static final String EMPTY = "empty";
    @Autowired
    private JedisCluster jedisCluster;

    private String getKey(String suid, String cid, boolean isFinished) {
        int finishedInt = isFinished ? 1 : 0;
        return new StringBuffer().append("special:practice:playlist:").append(suid).append(":").append(cid).append(":").append(finishedInt).toString();
    }

    private static int getEndIndex(int start, int size) {
        return size > 0 ? start + size - 1 : -1;
    }

    public void setSpecialPlaylist(String suid, String cid, Map<String, Integer> playlist2Percent, boolean isFinished) {
        try {
            HashMap pid2Score = Maps.newHashMap();
            if (ArrayMapTools.isNotEmpty((Map)pid2Score)) {
                playlist2Percent.forEach((k, v) -> pid2Score.put(k, v.doubleValue()));
            } else {
                pid2Score.put(EMPTY, -1.0);
            }
            String key = this.getKey(suid, cid, isFinished);
            this.jedisCluster.zadd(key, (Map)pid2Score);
            this.jedisCluster.expire(key, 3600);
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    public Map<String, Integer> getSpecialPlaylist(String suid, String cid, boolean isFinished, int start, int size) {
        try {
            String key = this.getKey(suid, cid, isFinished);
            System.out.println(key);
            Set tuples = this.jedisCluster.zrangeWithScores(key, (long)start, (long)SpecialPracticeCache.getEndIndex(start, size));
            if (ArrayMapTools.isEmpty((Collection)tuples)) {
                if (this.jedisCluster.exists(key).booleanValue()) {
                    return Maps.newHashMap();
                }
                return null;
            }
            LinkedHashMap playlist2Percent = Maps.newLinkedHashMap();
            for (Tuple tuple : tuples) {
                if (EMPTY.equals(tuple.getElement())) {
                    return Maps.newHashMap();
                }
                playlist2Percent.put(tuple.getElement(), (int)tuple.getScore());
            }
            return playlist2Percent;
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public int countSpecialPlaylist(String suid, String cid, boolean isFinished) {
        try {
            String key = this.getKey(suid, cid, isFinished);
            Long zrank = this.jedisCluster.zrank(key, EMPTY);
            if (null != zrank) {
                return 0;
            }
            Long total = this.jedisCluster.zcard(key);
            if (null != total) {
                return total.intValue();
            }
            return 0;
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            return -1;
        }
    }
}

