package com.jz.jar.media.proxy;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

import com.google.common.collect.Lists;
import com.jz.aliyun.beans.AliyunConfig;
import com.jz.aliyun.tools.OssTools;
import com.jz.common.utils.collection.ArrayMapTools;
import com.jz.common.utils.text.StringTools;
import com.jz.jar.media.common.ItemCard;
import com.jz.jar.media.service.MediaVideoService;
import com.jz.jar.media.tool.AliyunBean;
import com.jz.jar.media.wrapper.VideoWrapper;
import com.jz.jooq.media.tables.pojos.Video;

@Lazy
@Service
public class VideoProxy {

	@Autowired
	private MediaVideoService mediaVideoService;

	private String getSnapshotName(int cnt) {
		return (cnt < 10 ? "0000" : "000") + cnt;
	}

	private void getSnapshotUrl(String uid, Video video, VideoWrapper wrapper) {
		// 图片地址
		int cnt = 1;
		if (StringTools.isNotEmptyAndBlank(uid)) {
			cnt = uid.hashCode() % video.getSnapshotCnt();
		}
		String tempUrl = video.getSnapshotUrl().replace("{Count}", getSnapshotName(cnt));
		wrapper.setSnapshotUrl(AliyunBean.getScreenshotUrl(tempUrl));
	}

	/** 获取视频的相关文件路径 */
	private void getVideoUrl(String uid, Video video, VideoWrapper wrapper) {
		AliyunConfig aliyunConfig = AliyunBean.getMediaAliyunConfig();
		List<String> urls = Lists.newArrayList(video.getHd(), video.getNormal(), video.getNormal(), video.getAudit());
		// 一个小时
		Map<String, String> key2Url = OssTools.getInstance(aliyunConfig).getUrl(urls, 3600);
		// 视频地址
		wrapper.setHd(key2Url.get(video.getHd()));
		wrapper.setNormal(key2Url.get(video.getNormal()));
		wrapper.setLow(key2Url.get(video.getLow()));
		// 音频地址
		wrapper.setAudit(key2Url.get(video.getAudit()));
	}
	
	/** 获取视频卡片 */
	public ItemCard getVideoCard(String uid, String pid, String wid) {
		VideoWrapper wrapper = this.getVideoInfo(uid, pid, wid);
		if (null == wrapper)
			return null;
		return ItemCard.of(wrapper);
	}

	/** 获取视频信息 */
	public VideoWrapper getVideoInfo(String uid, String pid, String wid) {
		Video video = mediaVideoService.getVideo(wid);
		if (null == video)
			return null;
		return this.getVideoWrapper(uid, pid, video);
	}

	public List<ItemCard> getVideoCards(String uid, String pid, Collection<String> wids) {
		List<VideoWrapper> videos = this.getVideoInfo(uid, pid, wids);
		if (ArrayMapTools.isEmpty(videos))
			return null;
		return videos.stream().map(ItemCard::of).collect(Collectors.toList());
	}

	public List<VideoWrapper> getVideoInfo(String uid, String pid, Collection<String> wids) {
		List<Video> videos = mediaVideoService.findVideos(wids);
		if (ArrayMapTools.isEmpty(videos))
			return null;
		List<VideoWrapper> wrappers = Lists.newArrayList();
		for (Video it : videos) {
			wrappers.add(this.getVideoWrapper(uid, pid, it));
		}
		return wrappers;
	}

	public List<ItemCard> getVideoCards(String uid, Map<String, String> wid2Pids) {
		List<VideoWrapper> videos = this.getVideoInfo(uid, wid2Pids);
		if (ArrayMapTools.isEmpty(videos))
			return null;
		return videos.stream().map(ItemCard::of).collect(Collectors.toList());
	}

	public List<VideoWrapper> getVideoInfo(String uid, Map<String, String> wid2Pids) {
		// 获取视频信息
		List<Video> videos = mediaVideoService.findVideos(wid2Pids.keySet());
		if (ArrayMapTools.isEmpty(videos))
			return null;
		List<VideoWrapper> wrappers = Lists.newArrayList();
		for (Video it : videos) {
			wrappers.add(this.getVideoWrapper(uid, wid2Pids.get(it.getWid()), it));
		}
		return wrappers;
	}

	/** 获取视频信息 */
	private VideoWrapper getVideoWrapper(String uid, String pid, Video video) {
		VideoWrapper result = VideoWrapper.of(video).setPid(pid);
		// 获取可播放的地址
		this.getVideoUrl(uid, video, result);
		// 获取封面地址
		this.getSnapshotUrl(uid, video, result);
		return result;
	}
}
