/*
 * Decompiled with CFR 0.152.
 */
package com.jz.jar.media.proxy;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.jz.common.utils.collection.ArrayMapTools;
import com.jz.jar.media.service.PlaylistRelationService;
import com.jz.jooq.media.tables.pojos.PlaylistRelation;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

@Lazy
@Service
public class PlaylistRelationProxy {
    private static final Map<String, List<String>> cacheLevel2Topics = Maps.newHashMap();
    @Autowired
    private PlaylistRelationService playlistRelationService;

    public void loadRelationToCache() {
        List relations = this.playlistRelationService.findLevelTopics();
        if (ArrayMapTools.isEmpty((Collection)relations)) {
            return;
        }
        HashMap levelToTopics = Maps.newHashMap();
        for (PlaylistRelation r : relations) {
            if (!levelToTopics.containsKey(r.getLid())) {
                levelToTopics.put(r.getLid(), Lists.newArrayList());
            }
            ((List)levelToTopics.get(r.getLid())).add(r.getCid());
        }
        cacheLevel2Topics.clear();
        cacheLevel2Topics.putAll(levelToTopics);
    }

    public List<String> getLevels() {
        return Lists.newArrayList(cacheLevel2Topics.keySet());
    }

    public List<String> getTopicsForLevel(String levelId) {
        return Lists.newArrayList((Iterable)cacheLevel2Topics.get(levelId));
    }
}

