/*
 * Decompiled with CFR 0.152.
 */
package com.jz.jar.media.proxy;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.jz.common.utils.collection.ArrayMapTools;
import com.jz.jar.media.service.LevelService;
import com.jz.jooq.media.tables.pojos.Level;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

@Lazy
@Service
public class LevelProxy {
    private static final Map<String, Level> levelArray = Maps.newLinkedHashMap();
    @Autowired
    private LevelService levelService;

    public void loadLevelCache() {
        List levels = this.levelService.find();
        if (ArrayMapTools.isEmpty((Collection)levels)) {
            return;
        }
        levelArray.clear();
        levels.forEach(it -> levelArray.put(it.getLid(), (Level)it));
    }

    public List<Level> getLevels(List<String> lidArray) {
        ArrayList levels = Lists.newArrayList();
        levelArray.forEach((k, v) -> {
            if (lidArray.contains(k)) {
                levels.add(v);
            }
        });
        return levels;
    }

    public Level getLevelForAge(double age) {
        for (Level le : levelArray.values()) {
            if (!(le.getMinAge() <= age) || !(age <= le.getMaxAge())) continue;
            return le;
        }
        return null;
    }
}

