package com.jz.jar.media.proxy;

import java.util.List;
import java.util.Map;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.jz.common.utils.collection.ArrayMapTools;
import com.jz.jar.media.service.PlaylistRelationService;
import com.jz.jooq.media.tables.pojos.PlaylistRelation;

/**
 * @Title PlaylistRelationProxy
 * @Package com.jz.jar.media.proxy
 * @author tangjunfeng
 * @date 2018年8月10日 下午4:16:29
 * @version V1.0
 */
@Lazy
@Service
public class PlaylistRelationProxy {

	private static final Map<String, List<String>> cacheLevel2Topics = Maps.newHashMap();

	@Autowired
	private PlaylistRelationService playlistRelationService;
	
	/** 加载级别对应分类信息到缓存 */
	public void loadRelationToCache() {
		List<PlaylistRelation> relations = playlistRelationService.findLevelTopics();
		if (ArrayMapTools.isEmpty(relations))
			return;
		Map<String, List<String>> levelToTopics = Maps.newHashMap();
		for (PlaylistRelation r : relations) {
			if (!levelToTopics.containsKey(r.getLid())) {
				levelToTopics.put(r.getLid(), Lists.newArrayList());
			}
			levelToTopics.get(r.getLid()).add(r.getCid());
		}
		cacheLevel2Topics.clear();
		cacheLevel2Topics.putAll(levelToTopics);
	}
	
	public List<String> getLevels() {
		return Lists.newArrayList(cacheLevel2Topics.keySet());
	}

	public List<String> getTopicsForLevel(String levelId) {
		return Lists.newArrayList(cacheLevel2Topics.get(levelId));
	}
}
