/*
 * Decompiled with CFR 0.152.
 */
package com.jz.jar.media.proxy;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.jz.common.utils.collection.ArrayMapTools;
import com.jz.jar.media.service.LevelService;
import com.jz.jooq.media.tables.pojos.Level;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

@Lazy
@Service
public class LevelProxy {
    private static final Map<String, Level> levelArray = Maps.newHashMap();
    @Autowired
    private LevelService levelService;

    public void loadLevelCache() {
        List levels = this.levelService.find();
        if (ArrayMapTools.isEmpty((Collection)levels)) {
            return;
        }
        levelArray.clear();
        levelArray.putAll(levels.stream().collect(Collectors.toMap(it -> it.getLid(), it -> it)));
    }

    public List<Level> getLevels(List<String> lidArray) {
        return lidArray.stream().map(levelArray::get).collect(Collectors.toList());
    }

    public List<Level> getLevels() {
        return Lists.newArrayList(levelArray.values());
    }

    public Level getLevelForAge(double age) {
        for (Level le : levelArray.values()) {
            if (!(le.getMinAge() <= age) || !(age <= le.getMaxAge())) continue;
            return le;
        }
        return null;
    }

    public String getLevelIdForAge(double age) {
        Level level = this.getLevelForAge(age);
        return null != level ? level.getLid() : null;
    }
}

