package com.jz.jar.media.proxy;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

import com.jz.common.utils.text.StringTools;
import com.jz.jooq.media.tables.pojos.Level;

/**
 * @Title StudentLevelProxy
 * @Package com.jz.jar.media.proxy
 * @author tangjunfeng
 * @date 2018年8月10日 下午12:06:04
 * @version V1.0
 */
@Lazy
@Service
public class StudentLevelProxy {

	@Autowired
	private StudentInfoProxy studentInfoProxy;
	@Autowired
	private LevelProxy levelProxy;

	public Level getLevelForStudentAge(String puid, String suid) {
		if (!StringTools.allNotEmptyAndBlank(puid, suid))
			return null;
		double age = studentInfoProxy.getStudentAge(puid, suid);
		return levelProxy.getLevelForAge(age);
	}
}
