package com.jz.jar.media.proxy;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.List;
import java.util.Map;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.jz.common.utils.collection.ArrayMapTools;
import com.jz.common.utils.text.StringTools;
import com.jz.jar.media.service.MonthPlaySettingService;
import com.jz.jar.media.service.StudentMonthPlayService;
import com.jz.jar.media.wrapper.StudentMonthPlayWrapper;
import com.jz.jooq.media.tables.pojos.MonthPlaySetting;
import com.jz.jooq.media.tables.pojos.StudentMonthPlay;

@Lazy
@Service
public class StudentPlayProxy {

	private static final SimpleDateFormat month = new SimpleDateFormat("yyyyMM");

	@Autowired
	private MonthPlaySettingService monthPlaySettingService;
	@Autowired
	private StudentMonthPlayService studentMonthPlayService;

	@Autowired
	private StudentInfoProxy studentProxy;
	@Autowired
	private LevelProxy levelProxy;
	@Autowired
	private TopicProxy topicProxy;

	/** 获取学员月观看配置 */
	public List<MonthPlaySetting> getStudentMonthPlaySetting(String uid, String suid) {
		double age = studentProxy.getStudentAge(uid, suid);
		String level = levelProxy.getLevelIdForAge(age);
		if (null == level) // 年龄匹配失败
			return null;
		// 获取观看配置信息
		return monthPlaySettingService.findSettingForLid(level);
	}

	/** 获取学员月观看详情 */
	public List<StudentMonthPlayWrapper> getStudentPlayInfo(String uid, String suid) {
		// 获取观看配置信息
		List<MonthPlaySetting> settings = this.getStudentMonthPlaySetting(uid, suid);
		if (ArrayMapTools.isEmpty(settings))
			return null;
		// 根据当前月获取学员观看信息
		String currentMonth = month.format(Calendar.getInstance().getTime());
		List<StudentMonthPlay> plays = studentMonthPlayService.getStudentPlayForMonth(currentMonth, suid);
		Map<String, Integer> playCid2Minutes = Maps.newHashMap();
		if (ArrayMapTools.isNotEmpty(plays)) {
			for (StudentMonthPlay pl : plays) {
				playCid2Minutes.put(pl.getCid(), pl.getSeconds() / 60);
			}
		}

		List<StudentMonthPlayWrapper> wrappers = Lists.newArrayList();
		for (MonthPlaySetting set : settings) {
			wrappers.add(StudentMonthPlayWrapper.of(topicProxy.getTopic(set.getCid()).getName())
					.setTaskMinutes(set.getMinutes())
					.setPlayMinutes(ArrayMapTools.getInteger(playCid2Minutes, set.getCid(), 0)));
		}
		return wrappers;
	}

	public void saveMonthPlay(String puid, String suid, int seconds, List<String> topics) {
		String currentMonth = month.format(Calendar.getInstance().getTime());
		studentMonthPlayService.saveMonthPlay(currentMonth, StringTools.ternary(suid, puid), seconds, topics);
	}
}
