package com.jz.jar.media.proxy;

import java.util.List;
import java.util.Map.Entry;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Lists;
import com.google.common.collect.Table;
import com.jz.common.utils.collection.ArrayMapTools;
import com.jz.jar.media.service.LevelService;
import com.jz.jooq.media.tables.pojos.Level;

@Lazy
@Service
public class LevelProxy {

	private static final Table<String, Double, Double> tables = HashBasedTable.create();

	@Autowired
	private LevelService levelService;

	/** 加载级别到缓存中 */
	public void loadLevelCache() {
		List<Level> levels = levelService.find();
		if (ArrayMapTools.isEmpty(levels)) {
			return;
		}
		tables.clear();
		for (Level le : levels) {
			tables.put(le.getLid(), le.getMinAge(), le.getMaxAge());
		}
	}

	public List<String> getLevelIds() {
		return Lists.newArrayList(tables.rowKeySet());
	}

	public String getLevelIdForAge(double age) {
		for (String name : tables.rowKeySet()) {
			for (Entry<Double, Double> ages : tables.row(name).entrySet()) {
				if (ages.getKey() <= age && age <= ages.getValue()) {
					return name;
				}
			}
		}
		return null;
	}

}
