package com.jz.jar.media.proxy;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

import com.google.common.collect.Maps;
import com.jz.common.utils.collection.ArrayMapTools;
import com.jz.jar.media.common.ItemCard;
import com.jz.jar.media.service.UserPlayHistoryService;
import com.jz.jooq.media.tables.pojos.Playlist;
import com.jz.jooq.media.tables.pojos.UserPlayHistory;

/**
 * @Title PlaylistVideoProxy
 * @Package com.jz.jar.media.proxy
 * @author tangjunfeng
 * @date 2018年8月8日 下午6:26:16
 * @version V1.0
 */
@Lazy
@Service
public class PlaylistVideoProxy {

	@Autowired
	private UserPlayHistoryService userPlayHistoryService;

	@Autowired
	private VideoProxy videoProxy;

	/** 获取专辑下一个需要播放的视频 */
	public ItemCard getNextVideo(String uid, Playlist playlist) {
		int playlength = 0;
		String nextWid = playlist.getWid();
		if (null != uid) {
			// 获取当前专辑的播放历史
			UserPlayHistory history = userPlayHistoryService.getHistory(uid, playlist.getPid());
			if (null != history) {
				playlength = history.getPlayLength();
				nextWid = history.getNextWid();
			}
		}
		ItemCard videoCard = videoProxy.getVideoCard(uid, playlist.getPid(), nextWid);
		if (null != videoCard) {
			videoCard.getVideo().setPlayLength(playlength);
		}
		return videoCard;
	}

	/** 获取专辑下一个需要播放的视频 */
	public Map<String, ItemCard> getNextVideo(String uid, Collection<Playlist> playlistArray) {
		Map<String, String> wid2Pids = playlistArray.stream()
				.collect(Collectors.toMap(it -> it.getWid(), it -> it.getPid()));
		Map<String, Integer> wid2Playlength = Maps.newHashMap();
		if (null != uid) {
			List<String> pids = playlistArray.stream().map(it -> it.getPid()).collect(Collectors.toList());
			// 获取当前专辑的播放历史
			List<UserPlayHistory> histories = userPlayHistoryService.getHistories(uid, pids);
			if (ArrayMapTools.isNotEmpty(histories)) {
				histories.forEach(it -> {
					wid2Pids.put(it.getNextWid(), it.getPid());
					wid2Playlength.put(it.getNextWid(), it.getPlayLength());
				});
			}
		}
		Map<String, ItemCard> pid2VideoCard = Maps.newHashMap();
		List<ItemCard> videoCard = videoProxy.getVideoCards(uid, wid2Pids);
		if (ArrayMapTools.isNotEmpty(videoCard)) {
			for (ItemCard it : videoCard) {
				pid2VideoCard.put(it.getVideo().getPid(), it);
				if (wid2Playlength.containsKey(it.getVideo().getWid())) {
					it.getVideo().setPlayLength(wid2Playlength.get(it.getVideo().getWid()));
					continue;
				}
				it.getVideo().setPlayLength(0);
			}
		}
		return pid2VideoCard;
	}
}
