/*
 * Decompiled with CFR 0.152.
 */
package com.jz.jar.media.proxy;

import com.google.common.collect.Lists;
import com.jz.common.utils.collection.ArrayMapTools;
import com.jz.common.utils.text.StringTools;
import com.jz.jar.franchise.service.StudentInfoService;
import com.jz.jar.media.proxy.PlayTitleProxy;
import com.jz.jar.media.tool.Global;
import com.jz.jar.media.wrapper.StudentWrapper;
import com.jz.jooq.franchise.tables.pojos.StudentInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

@Lazy
@Service
public class StudentInfoProxy {
    @Autowired
    private StudentInfoService studentInfoService;
    @Autowired
    private PlayTitleProxy playTitleProxy;

    public List<StudentWrapper> getStudents(String puid) {
        List students = this.studentInfoService.getStudents(puid);
        if (ArrayMapTools.isEmpty((Collection)students)) {
            return null;
        }
        ArrayList wrappers = Lists.newArrayList();
        for (StudentInfo st : students) {
            wrappers.add(StudentWrapper.of(st).setAge(this.getStudentAge(st)).setPlayTitle(this.playTitleProxy.getTitle(puid, st.getSuid())));
        }
        return wrappers;
    }

    private int getStudentAge(StudentInfo studentInfo) {
        int tempAge = Global.getAge(studentInfo.getBirthday()).intValue();
        return tempAge <= 0 ? 1 : tempAge;
    }

    public double getStudentAge(String puid, String suid) {
        String birthday = this.studentInfoService.getStudentBirthday(puid, suid);
        if (StringTools.isEmptyAndBlank((String)birthday)) {
            return 0.0;
        }
        return Global.getAge(birthday);
    }
}

