package com.jz.jar.media.wrapper;

import com.jz.jar.media.common.ItemCard;
import com.jz.jooq.media.tables.pojos.Playlist;

/**
 * @Title PlaylistWrapper
 * @Package com.jz.playabc.api.wrapper
 * @author tangjunfeng
 * @date 2018年8月2日 下午12:17:11
 * @version V1.0
 */
public class PlaylistWrapper {
	private PlaylistWrapper() {
	}

	private String pid;
	private String name;
	private String thumnail;
	private Integer videoCnt;

	private ItemCard video;

	// 是否收藏
	private Boolean isCollect;
	// 是否推荐
	private Boolean isRecomm;

	public static PlaylistWrapper of(Playlist playlist) {
		return new PlaylistWrapper().setPid(playlist.getPid()).setName(playlist.getName())
				.setThumnail(playlist.getThumnail()).setVideoCnt(playlist.getVideoCnt());
	}

	public String getPid() {
		return pid;
	}

	public PlaylistWrapper setPid(String pid) {
		this.pid = pid;
		return this;
	}

	public String getName() {
		return name;
	}

	public PlaylistWrapper setName(String name) {
		this.name = name;
		return this;
	}

	public String getThumnail() {
		return thumnail;
	}

	public PlaylistWrapper setThumnail(String thumnail) {
		this.thumnail = thumnail;
		return this;
	}

	public Integer getVideoCnt() {
		return videoCnt;
	}

	public PlaylistWrapper setVideoCnt(Integer videoCnt) {
		this.videoCnt = videoCnt;
		return this;
	}

	public ItemCard getVideo() {
		return video;
	}

	public PlaylistWrapper setVideo(ItemCard video) {
		this.video = video;
		return this;
	}

	public Boolean getIsCollect() {
		return isCollect;
	}

	public PlaylistWrapper setIsCollect(Boolean isCollect) {
		this.isCollect = isCollect;
		return this;
	}

	public Boolean getIsRecomm() {
		return isRecomm;
	}

	public PlaylistWrapper setIsRecomm(Boolean isRecomm) {
		this.isRecomm = isRecomm;
		return this;
	}

}
