/*
 * Decompiled with CFR 0.152.
 */
package com.jz.jar.media.proxy;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.jz.common.utils.collection.ArrayMapTools;
import com.jz.jar.media.proxy.LevelProxy;
import com.jz.jar.media.proxy.StudentInfoProxy;
import com.jz.jar.media.proxy.TopicProxy;
import com.jz.jar.media.service.MonthPlaySettingService;
import com.jz.jar.media.service.StudentMonthPlayService;
import com.jz.jar.media.wrapper.StudentMonthPlayWrapper;
import com.jz.jooq.media.tables.pojos.MonthPlaySetting;
import com.jz.jooq.media.tables.pojos.StudentMonthPlay;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

@Lazy
@Service
public class StudentPlayProxy {
    private static final SimpleDateFormat month = new SimpleDateFormat("yyyyMM");
    @Autowired
    private MonthPlaySettingService monthPlaySettingService;
    @Autowired
    private StudentMonthPlayService studentMonthPlayService;
    @Autowired
    private StudentInfoProxy studentProxy;
    @Autowired
    private LevelProxy levelProxy;
    @Autowired
    private TopicProxy topicProxy;

    public List<StudentMonthPlayWrapper> getStudentPlayInfo(String uid, String suid) {
        double age = this.studentProxy.getStudentAge(uid, suid);
        String level = this.levelProxy.getLevelIdForAge(age);
        if (null == level) {
            return null;
        }
        List settings = this.monthPlaySettingService.findSettingForLid(level);
        if (ArrayMapTools.isEmpty((Collection)settings)) {
            return null;
        }
        String currentMonth = month.format(Calendar.getInstance().getTime());
        List plays = this.studentMonthPlayService.getStudentPlayForMonth(currentMonth, suid);
        HashMap playCid2Minutes = Maps.newHashMap();
        if (ArrayMapTools.isNotEmpty((Collection)plays)) {
            for (StudentMonthPlay pl : plays) {
                playCid2Minutes.put(pl.getCid(), pl.getSeconds() / 60);
            }
        }
        ArrayList wrappers = Lists.newArrayList();
        for (MonthPlaySetting set : settings) {
            wrappers.add(StudentMonthPlayWrapper.of(this.topicProxy.getTopic(set.getCid()).getName()).setTaskMinutes(set.getMinutes()).setPlayMinutes(ArrayMapTools.getInteger((Map)playCid2Minutes, (Object)set.getCid(), (Integer)0)));
        }
        return wrappers;
    }
}

