/*
 * Decompiled with CFR 0.152.
 */
package com.jz.jar.media.proxy;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Lists;
import com.google.common.collect.Table;
import com.jz.common.utils.collection.ArrayMapTools;
import com.jz.jar.media.service.LevelService;
import com.jz.jooq.media.tables.pojos.Level;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

@Lazy
@Service
public class LevelProxy {
    private static final Table<String, Double, Double> tables = HashBasedTable.create();
    @Autowired
    private LevelService levelService;

    public void loadLevelCache() {
        List levels = this.levelService.find();
        if (ArrayMapTools.isEmpty((Collection)levels)) {
            return;
        }
        tables.clear();
        for (Level le : levels) {
            tables.put((Object)le.getLid(), (Object)le.getMinAge(), (Object)le.getMaxAge());
        }
    }

    public List<String> getLevelIds() {
        return Lists.newArrayList((Iterable)tables.rowKeySet());
    }

    public String getLevelIdForAge(double age) {
        for (String name : tables.rowKeySet()) {
            for (Map.Entry ages : tables.row((Object)name).entrySet()) {
                if (!((Double)ages.getKey() <= age) || !(age <= (Double)ages.getValue())) continue;
                return name;
            }
        }
        return null;
    }
}

