/*
 * Decompiled with CFR 0.152.
 */
package com.jz.jar.media.proxy;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.jz.common.utils.collection.ArrayMapTools;
import com.jz.jar.media.service.LevelTopicService;
import com.jz.jooq.media.tables.pojos.LevelTopic;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

@Lazy
@Service
public class LevelTopicProxy {
    private static final Map<String, List<String>> level2Topics = Maps.newHashMap();
    @Autowired
    private LevelTopicService levelTopicService;

    public void loadLevelTopicCache() {
        List levelTopics = this.levelTopicService.find();
        if (ArrayMapTools.isEmpty((Collection)levelTopics)) {
            return;
        }
        level2Topics.clear();
        for (LevelTopic lt : levelTopics) {
            if (!level2Topics.containsKey(lt.getLid())) {
                level2Topics.put(lt.getLid(), Lists.newArrayList());
            }
            level2Topics.get(lt.getLid()).add(lt.getCid());
        }
    }

    public List<String> getLevelTopics(String level) {
        return Lists.newArrayList((Iterable)level2Topics.get(level));
    }
}

