package com.jz.jar.media.common;

import com.jz.jar.media.wrapper.LevelWrapper;
import com.jz.jar.media.wrapper.PlaylistWrapper;
import com.jz.jar.media.wrapper.TopicWrapper;
import com.jz.jar.media.wrapper.VideoWrapper;

/**
 * @Title ItemCard
 * @Package com.jz.jar.media.common
 * @author tangjunfeng
 * @date 2018年8月3日 下午6:35:46
 * @version V1.0
 */
public class ItemCard {
	private ItemCard() {
	}

	private ItemCard(CardType type) {
		this.type = type;
	}

	private CardType type;

	private VideoWrapper video;
	private PlaylistWrapper playlist;
	private LevelWrapper level;
	private TopicWrapper topic;

	public static ItemCard of() {
		return new ItemCard();
	}

	public static ItemCard of(VideoWrapper video) {
		return new ItemCard(CardType.video).setVideo(video);
	}

	public static ItemCard of(PlaylistWrapper playlist) {
		return new ItemCard(CardType.playlist).setPlaylist(playlist);
	}

	public static ItemCard of(LevelWrapper level) {
		return new ItemCard(CardType.level).setLevel(level);
	}
	
	public static ItemCard of(TopicWrapper topic) {
		return new ItemCard(CardType.topic).setTopic(topic);
	}
	
	public CardType getType() {
		return type;
	}

	public ItemCard setType(CardType type) {
		this.type = type;
		return this;
	}

	public VideoWrapper getVideo() {
		return video;
	}

	public ItemCard setVideo(VideoWrapper video) {
		this.video = video;
		return this;
	}

	public PlaylistWrapper getPlaylist() {
		return playlist;
	}

	public ItemCard setPlaylist(PlaylistWrapper playlist) {
		this.playlist = playlist;
		return this;
	}

	public LevelWrapper getLevel() {
		return level;
	}

	public ItemCard setLevel(LevelWrapper level) {
		this.level = level;
		return this;
	}

	public TopicWrapper getTopic() {
		return topic;
	}

	public ItemCard setTopic(TopicWrapper topic) {
		this.topic = topic;
		return this;
	}

}
