/*
 * Decompiled with CFR 0.152.
 */
package com.jz.jar.media.proxy;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.jz.common.utils.collection.ArrayMapTools;
import com.jz.jar.media.common.ItemCard;
import com.jz.jar.media.service.TopicService;
import com.jz.jar.media.tool.AliyunBean;
import com.jz.jar.media.wrapper.TopicWrapper;
import com.jz.jooq.media.tables.pojos.Topic;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

@Lazy
@Service
public class TopicProxy {
    private static final Map<String, Topic> id2Topic = Maps.newHashMap();
    @Autowired
    private TopicService topicService;

    public void loadTopicCache() {
        List topics = this.topicService.findOnline();
        if (ArrayMapTools.isEmpty((Collection)topics)) {
            return;
        }
        id2Topic.clear();
        for (Topic it : topics) {
            it.setPic(AliyunBean.getScreenshotUrl(it.getPic()));
            id2Topic.put(it.getCid(), it);
        }
    }

    public Map<String, Topic> getTopics(Collection<String> topicIds) {
        if (ArrayMapTools.isEmpty(topicIds)) {
            return Maps.newHashMap();
        }
        HashMap tempResult = Maps.newHashMap();
        Sets.newHashSet(topicIds).forEach(it -> {
            if (!id2Topic.containsKey(it)) {
                return;
            }
            tempResult.put(it, id2Topic.get(it));
        });
        return tempResult;
    }

    public Topic getTopic(String cid) {
        return id2Topic.get(cid);
    }

    public TopicWrapper getTopicWrapper(String cid) {
        Topic topic = id2Topic.get(cid);
        if (null == topic) {
            return null;
        }
        return TopicWrapper.of(topic);
    }

    public List<TopicWrapper> getTopicWrappers(Collection<String> cids) {
        return cids.stream().map(id2Topic::get).filter(it -> it != null).map(TopicWrapper::of).collect(Collectors.toList());
    }

    public List<Topic> getPHomeTopics() {
        return id2Topic.values().stream().filter(it -> it.getPhomeShow() == 1).sorted(new Comparator<Topic>(){

            @Override
            public int compare(Topic o1, Topic o2) {
                return Integer.compare(o1.getSeq(), o2.getSeq());
            }
        }).collect(Collectors.toList());
    }

    public List<TopicWrapper> getPHomeTopicWrapper() {
        return this.getPHomeTopics().stream().map(TopicWrapper::of).collect(Collectors.toList());
    }

    public List<ItemCard> getPHomeTopicCard() {
        return this.getPHomeTopicWrapper().stream().map(ItemCard::of).collect(Collectors.toList());
    }
}

