package com.jz.jar.media.request;

import java.util.Collection;

/**
 * @Title PlaylistRequest
 * @Package com.jz.jar.media.request
 * @author tangjunfeng
 * @date 2018年8月3日 下午5:31:36
 * @version V1.0
 */
public class PlaylistRequest {
	private PlaylistRequest() {
	}

	private String pid;
	private Collection<String> pids;
	private String uid;
	private String bid;
	private Boolean isCollect;
	private Boolean isRecomm;

	public static PlaylistRequest of(String uid, String bid, String pid) {
		return new PlaylistRequest().setUid(uid).setBid(bid).setPid(pid);
	}

	public static PlaylistRequest of(String uid, String bid, String pid, boolean isRecomm) {
		return of(uid, bid, pid).setIsRecomm(isRecomm);
	}

	public static PlaylistRequest of(String uid, String bid, String pid, boolean isRecomm, boolean isCollect) {
		return of(uid, bid, pid, isRecomm).setIsCollect(isCollect);
	}

	public static PlaylistRequest of(String uid, String bid, Collection<String> pids) {
		return new PlaylistRequest().setUid(uid).setBid(bid).setPids(pids);
	}

	public static PlaylistRequest of(String uid, String bid, Collection<String> pids, boolean isRecomm) {
		return of(uid, bid, pids).setIsRecomm(isRecomm);
	}

	public static PlaylistRequest of(String uid, String bid, Collection<String> pids, boolean isRecomm,
			boolean isCollect) {
		return of(uid, bid, pids, isRecomm).setIsCollect(isCollect);
	}

	public String getPid() {
		return pid;
	}

	public PlaylistRequest setPid(String pid) {
		this.pid = pid;
		return this;
	}

	public Collection<String> getPids() {
		return pids;
	}

	public PlaylistRequest setPids(Collection<String> pids) {
		this.pids = pids;
		return this;
	}

	public String getUid() {
		return uid;
	}

	public PlaylistRequest setUid(String uid) {
		this.uid = uid;
		return this;
	}

	public String getBid() {
		return bid;
	}

	public PlaylistRequest setBid(String bid) {
		this.bid = bid;
		return this;
	}

	public Boolean getIsCollect() {
		return isCollect;
	}

	public PlaylistRequest setIsCollect(Boolean isCollect) {
		this.isCollect = isCollect;
		return this;
	}

	public Boolean getIsRecomm() {
		return isRecomm;
	}

	public PlaylistRequest setIsRecomm(Boolean isRecomm) {
		this.isRecomm = isRecomm;
		return this;
	}

}
