package com.jz.jar.media.proxy;

import java.util.List;
import java.util.Map;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.jz.common.utils.collection.ArrayMapTools;
import com.jz.jar.media.service.LevelTopicService;
import com.jz.jooq.media.tables.pojos.LevelTopic;

@Lazy
@Service
public class LevelTopicProxy {

	private static final Map<String, List<String>> level2Topics = Maps.newHashMap();

	@Autowired
	private LevelTopicService levelTopicService;

	/** 加载级别对应topic到缓存中 */
	public void loadLevelTopicCache() {
		List<LevelTopic> levelTopics = levelTopicService.find();
		if (ArrayMapTools.isEmpty(levelTopics)) {
			return;
		}
		level2Topics.clear();
		for (LevelTopic lt : levelTopics) {
			if (!level2Topics.containsKey(lt.getLid())) {
				level2Topics.put(lt.getLid(), Lists.newArrayList());
			}
			level2Topics.get(lt.getLid()).add(lt.getCid());
		}
	}

	public List<String> getLevelTopics(String level) {
		return Lists.newArrayList(level2Topics.get(level));
	}

}
