/*
 * Decompiled with CFR 0.152.
 */
package com.jz.jar.media.proxy;

import com.google.common.collect.Lists;
import com.jz.aliyun.beans.AliyunConfig;
import com.jz.aliyun.tools.OssTools;
import com.jz.common.utils.collection.ArrayMapTools;
import com.jz.common.utils.text.StringTools;
import com.jz.jar.media.common.ItemCard;
import com.jz.jar.media.service.MediaVideoService;
import com.jz.jar.media.service.UserCollectService;
import com.jz.jar.media.tool.AliyunBean;
import com.jz.jar.media.wrapper.VideoWrapper;
import com.jz.jooq.media.tables.pojos.Video;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

@Lazy
@Service
public class VideoProxy {
    @Autowired
    private MediaVideoService mediaVideoService;
    @Autowired
    private UserCollectService userCollectService;

    private String getSnapshotName(int cnt) {
        return (cnt < 10 ? "0000" : "000") + cnt;
    }

    public void getSnapshotUrl(String uid, Video video, VideoWrapper wrapper) {
        int cnt = 1;
        if (StringTools.isNotEmptyAndBlank((String)uid)) {
            cnt = uid.hashCode() % video.getSnapshotCnt();
        }
        String tempUrl = video.getSnapshotUrl().replace("{Count}", this.getSnapshotName(cnt));
        wrapper.setSnapshotUrl(AliyunBean.getScreenshotUrl(tempUrl));
    }

    public void getVideoUrl(String uid, Video video, VideoWrapper wrapper) {
        AliyunConfig aliyunConfig = AliyunBean.getMediaAliyunConfig();
        ArrayList urls = Lists.newArrayList((Object[])new String[]{video.getHd(), video.getNormal(), video.getNormal(), video.getAudit()});
        Map key2Url = OssTools.getInstance((AliyunConfig)aliyunConfig).getUrl((Collection)urls, 3600);
        wrapper.setHd((String)key2Url.get(video.getHd()));
        wrapper.setNormal((String)key2Url.get(video.getNormal()));
        wrapper.setLow((String)key2Url.get(video.getLow()));
        wrapper.setAudit((String)key2Url.get(video.getAudit()));
    }

    public List<ItemCard> getVideoCards(String uid, String bid, String pid, Collection<String> wids) {
        List<VideoWrapper> videos = this.getVideoWrapper(uid, bid, pid, wids);
        if (ArrayMapTools.isEmpty(videos)) {
            return null;
        }
        return videos.stream().map(ItemCard::of).collect(Collectors.toList());
    }

    public List<VideoWrapper> getVideoWrapper(String uid, String bid, String pid, Collection<String> wids) {
        List videos = this.mediaVideoService.findVideos(wids);
        if (ArrayMapTools.isEmpty((Collection)videos)) {
            return null;
        }
        boolean isCollect = false;
        if (StringTools.allNotEmptyAndBlank((String[])new String[]{uid, bid, pid})) {
            isCollect = this.userCollectService.isCollect(uid, bid, pid);
        }
        ArrayList wrappers = Lists.newArrayList();
        VideoWrapper tempVideo = null;
        for (Video it : videos) {
            tempVideo = VideoWrapper.of(it).setPid(pid).setIsCollect(isCollect);
            this.getSnapshotUrl(uid, it, tempVideo);
            wrappers.add(tempVideo);
        }
        return wrappers;
    }
}

