/*
 * Decompiled with CFR 0.152.
 */
package com.jz.jar.media.proxy;

import com.google.common.collect.Lists;
import com.jz.common.utils.collection.ArrayMapTools;
import com.jz.common.utils.text.StringTools;
import com.jz.jar.media.common.ItemCard;
import com.jz.jar.media.request.PlaylistRequest;
import com.jz.jar.media.service.PlaylistService;
import com.jz.jar.media.service.UserCollectService;
import com.jz.jar.media.tool.AliyunBean;
import com.jz.jar.media.wrapper.PlaylistWrapper;
import com.jz.jooq.media.tables.pojos.Playlist;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

@Lazy
@Service
public class PlaylistProxy {
    @Autowired
    private PlaylistService playlistService;
    @Autowired
    private UserCollectService userCollectService;

    public PlaylistWrapper getSinglePlaylist(String uid, String bid, String pid) {
        return this.getSinglePlaylist(PlaylistRequest.of(uid, bid, pid));
    }

    public PlaylistWrapper getSinglePlaylist(PlaylistRequest req) {
        Playlist pl = this.playlistService.getPlaylist(req.getPid());
        if (null == pl) {
            return null;
        }
        PlaylistWrapper wp = PlaylistWrapper.of(pl).setThumnail(AliyunBean.getScreenshotUrl(pl.getThumnail()));
        if (StringTools.allNotEmptyAndBlank((String[])new String[]{req.getUid(), req.getBid()})) {
            wp.setIsCollect(this.userCollectService.isCollect(req.getUid(), req.getBid(), req.getPid()));
        } else {
            wp.setIsCollect(false);
        }
        return wp;
    }

    public List<ItemCard> getMultiPlaylist(String uid, String bid, Collection<String> pids, boolean isRecomm) {
        return this.getMultiPlaylist(PlaylistRequest.of(uid, bid, pids, isRecomm));
    }

    public List<ItemCard> getMultiPlaylist(String uid, String bid, Collection<String> pids, boolean isRecomm, boolean isCollect) {
        return this.getMultiPlaylist(PlaylistRequest.of(uid, bid, pids, isRecomm, isCollect));
    }

    public List<ItemCard> getMultiPlaylist(PlaylistRequest req) {
        List playlistArray = this.playlistService.getPlaylist(req.getPids());
        if (ArrayMapTools.isEmpty((Collection)playlistArray)) {
            return null;
        }
        List collectPlaylist = null;
        if (null == req.getIsCollect()) {
            if (StringTools.allNotEmptyAndBlank((String[])new String[]{req.getUid(), req.getBid()})) {
                collectPlaylist = this.userCollectService.getExistCollect(req.getUid(), req.getBid(), req.getPids());
            }
            if (null == collectPlaylist) {
                collectPlaylist = Lists.newArrayList();
            }
        }
        ArrayList cards = Lists.newArrayList();
        PlaylistWrapper wp = null;
        for (Playlist pl : playlistArray) {
            wp = PlaylistWrapper.of(pl).setThumnail(AliyunBean.getScreenshotUrl(pl.getThumnail()));
            wp.setIsCollect(null != collectPlaylist ? collectPlaylist.contains(pl.getId()) : req.getIsCollect().booleanValue());
            wp.setIsRecomm(req.getIsRecomm());
            cards.add(ItemCard.of(wp));
        }
        return cards;
    }

    public List<ItemCard> getRecommPlaylistForMaxWatchCnt(String uid, String bid, int recommCnt) {
        List pids = this.playlistService.getMaxWatchCntPid(recommCnt);
        if (ArrayMapTools.isEmpty((Collection)pids)) {
            return null;
        }
        return this.getMultiPlaylist(PlaylistRequest.of(uid, bid, pids, true));
    }
}

