/*
 * Decompiled with CFR 0.152.
 */
package com.jz.jar.media.common;

import com.jz.jar.media.common.CardType;
import com.jz.jar.media.wrapper.LevelWrapper;
import com.jz.jar.media.wrapper.PlaylistWrapper;
import com.jz.jar.media.wrapper.VideoWrapper;

public class ItemCard {
    private CardType type;
    private VideoWrapper video;
    private PlaylistWrapper playlist;
    private LevelWrapper level;

    private ItemCard() {
    }

    private ItemCard(CardType type) {
        this.type = type;
    }

    public static ItemCard of() {
        return new ItemCard();
    }

    public static ItemCard of(VideoWrapper video) {
        return new ItemCard(CardType.video).setVideo(video);
    }

    public static ItemCard of(PlaylistWrapper playlist) {
        return new ItemCard(CardType.playlist).setPlaylist(playlist);
    }

    public static ItemCard of(LevelWrapper level) {
        return new ItemCard(CardType.level).setLevel(level);
    }

    public CardType getType() {
        return this.type;
    }

    public ItemCard setType(CardType type) {
        this.type = type;
        return this;
    }

    public VideoWrapper getVideo() {
        return this.video;
    }

    public ItemCard setVideo(VideoWrapper video) {
        this.video = video;
        return this;
    }

    public PlaylistWrapper getPlaylist() {
        return this.playlist;
    }

    public ItemCard setPlaylist(PlaylistWrapper playlist) {
        this.playlist = playlist;
        return this;
    }

    public LevelWrapper getLevel() {
        return this.level;
    }

    public ItemCard setLevel(LevelWrapper level) {
        this.level = level;
        return this;
    }
}

