package com.jz.jar.media.proxy;

import java.util.List;
import java.util.Map;

import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

import com.google.common.collect.Lists;
import com.jz.aliyun.beans.AliyunConfig;
import com.jz.aliyun.tools.OssTools;
import com.jz.common.utils.text.StringTools;
import com.jz.jar.media.tool.AliyunBean;
import com.jz.jar.media.wrapper.VideoWrapper;
import com.jz.jooq.media.tables.pojos.Video;

@Lazy
@Service
public class VideoProxy {

	private String getSnapshotName(int cnt) {
		return (cnt < 10 ? "0000" : "000") + cnt;
	}

	public void getSnapshotUrl(String uid, Video video, VideoWrapper wrapper) {
		// 图片地址
		int cnt = 1;
		if (StringTools.isNotEmptyAndBlank(uid)) {
			cnt = uid.hashCode() % video.getSnapshotCnt();
		}
		String tempUrl = video.getSnapshotUrl().replace("{Count}", getSnapshotName(cnt));
		wrapper.setSnapshotUrl(AliyunBean.getScreenshotUrl(tempUrl));
	}

	/** 获取视频的相关文件路径 */
	public void getVideoUrl(String uid, Video video, VideoWrapper wrapper) {
		AliyunConfig aliyunConfig = AliyunBean.getMediaAliyunConfig();
		List<String> urls = Lists.newArrayList(video.getHd(), video.getNormal(), video.getNormal(), video.getAudit());
		// 一个小时
		Map<String, String> key2Url = OssTools.getInstance(aliyunConfig).getUrl(urls, 3600);
		// 视频地址
		wrapper.setHd(key2Url.get(video.getHd()));
		wrapper.setNormal(key2Url.get(video.getNormal()));
		wrapper.setLow(key2Url.get(video.getLow()));
		// 音频地址
		wrapper.setAudit(key2Url.get(video.getAudit()));
	}
}
