package com.jz.jar.media.proxy;

import java.util.Collection;
import java.util.List;
import java.util.Map;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.jz.common.utils.collection.ArrayMapTools;
import com.jz.common.utils.text.StringTools;
import com.jz.jar.media.service.TopicService;
import com.jz.jooq.media.tables.pojos.Topic;

@Lazy
@Service
public class TopicProxy {

	/* id对应实例 */
	private static final Map<String, Topic> id2Topic = Maps.newHashMap();
	/* 父级对应所有的子类 */
	private static final Map<String, List<Topic>> parent2Children = Maps.newHashMap();

	@Autowired
	private TopicService topicService;

	/** 加载topic入缓存 */
	public void loadTopicCache() {
		List<Topic> topics = topicService.find();
		if (ArrayMapTools.isEmpty(topics)) {
			return;
		}

		for (Topic it : topics) {
			id2Topic.put(it.getId(), it);
			if (StringTools.isEmptyAndBlank(it.getParent()))
				continue;
			if (!parent2Children.containsKey(it.getParent())) {
				parent2Children.put(it.getParent(), Lists.newArrayList());
			}
			parent2Children.get(it.getParent()).add(it);
		}
	}
	
	public Map<String, Topic> getTopics(Collection<String> topicIds) {
		if (ArrayMapTools.isEmpty(topicIds))
			return Maps.newHashMap();

		Map<String, Topic> tempResult = Maps.newHashMap();
		Sets.newHashSet(topicIds).forEach(it -> {
			if (!id2Topic.containsKey(it))
				return;
			tempResult.put(it, id2Topic.get(it));
		});
		return tempResult;
	}
}
