package com.jz.jar.media.proxy;

import java.util.Collection;
import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

import com.google.common.collect.Lists;
import com.jz.common.utils.collection.ArrayMapTools;
import com.jz.jar.media.service.PlaylistService;
import com.jz.jar.media.service.UserCollectService;
import com.jz.jar.media.tool.AliyunBean;
import com.jz.jar.media.wrapper.PlaylistWrapper;
import com.jz.jooq.media.tables.pojos.Playlist;

@Lazy
@Service
public class PlaylistProxy {

	@Autowired
	private PlaylistService playlistService;
	@Autowired
	private UserCollectService userCollectService;

	public PlaylistWrapper getPlaylist(String uid, String bid, String pid) {
		Playlist pl = playlistService.getPlaylist(pid);
		if (null == pl)
			return null;
		PlaylistWrapper wp = PlaylistWrapper.of(pl).setThumnail(AliyunBean.getScreenshotUrl(pl.getThumnail()));
		wp.setIsCollect(userCollectService.isCollect(uid, bid, pid));
		return wp;
	}

	public List<PlaylistWrapper> getPlaylist(Collection<String> pids, String uid, String bid, Boolean isCollect,
			boolean isRecomm) {
		List<Playlist> playlistArray = playlistService.getPlaylist(pids);
		if (ArrayMapTools.isEmpty(playlistArray))
			return null;
		List<String> collectPlaylist = null;
		if (null == isCollect) { // 获取已经收藏的专辑
			collectPlaylist = userCollectService.getExistCollect(uid, bid, pids);
			if (null == collectPlaylist)
				collectPlaylist = Lists.newArrayList();
		}
		List<PlaylistWrapper> wrappers = Lists.newArrayList();
		PlaylistWrapper wp = null;
		for (Playlist pl : playlistArray) {
			wp = PlaylistWrapper.of(pl).setThumnail(AliyunBean.getScreenshotUrl(pl.getThumnail()));
			wp.setIsCollect(null != collectPlaylist ? collectPlaylist.contains(pl.getId()) : isCollect);
			wp.setIsRecomm(isRecomm);
			wrappers.add(wp);
		}
		return wrappers;
	}
	
	/** 获取推荐的专辑信息,根据专辑的最大播放数 */
	public List<PlaylistWrapper> getRecommPlaylistForMaxWatchCnt(String uid, String bid, int recommCnt) {
		List<String> pids = playlistService.getMaxWatchCntPid(recommCnt);
		if (ArrayMapTools.isEmpty(pids))
			return null;
		return this.getPlaylist(pids, uid, bid, null, true);
	}
}
