/*
 * Decompiled with CFR 0.152.
 */
package com.jz.jar.media.proxy;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.jz.common.utils.collection.ArrayMapTools;
import com.jz.jar.media.service.AgeGroupService;
import com.jz.jar.media.service.AgeTopicService;
import com.jz.jooq.media.tables.pojos.AgeGroup;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

@Lazy
@Service
public class AgeProxy {
    private static final Map<AgeGroup, List<String>> age2Topics = Maps.newLinkedHashMap();
    @Autowired
    private AgeGroupService ageGroupService;
    @Autowired
    private AgeTopicService ageTopicService;

    public void loadAgeCache() {
        List groups = this.ageGroupService.find();
        if (ArrayMapTools.isEmpty((Collection)groups)) {
            return;
        }
        Map<String, List<String>> tempAgeTopic = this.findAgeTopics();
        for (AgeGroup it : groups) {
            age2Topics.put(it, tempAgeTopic.get(it.getId()));
        }
    }

    private Map<String, List<String>> findAgeTopics() {
        List ageTopics = this.ageTopicService.find();
        if (ArrayMapTools.isEmpty((Collection)ageTopics)) {
            return Maps.newHashMap();
        }
        HashMap aid2Topics = Maps.newHashMap();
        ageTopics.forEach(it -> {
            if (!aid2Topics.containsKey(it.getAid())) {
                aid2Topics.put(it.getAid(), Lists.newArrayList());
            }
            ((List)aid2Topics.get(it.getAid())).add(it.getTid());
        });
        return aid2Topics;
    }

    public List<AgeGroup> getAges() {
        return age2Topics.keySet().stream().collect(Collectors.toList());
    }

    public Map<AgeGroup, List<String>> getAge2Topics() {
        return Maps.newLinkedHashMap(age2Topics);
    }
}

