/*
 * Decompiled with CFR 0.152.
 */
package com.jz.jar.media.proxy;

import com.google.common.collect.Lists;
import com.jz.aliyun.beans.AliyunConfig;
import com.jz.aliyun.tools.OssTools;
import com.jz.common.utils.text.StringTools;
import com.jz.jar.media.tool.AliyunBean;
import com.jz.jar.media.wrapper.VideoWrapper;
import com.jz.jooq.media.tables.pojos.Video;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.springframework.stereotype.Component;

@Component
public class VideoProxy {
    private String getSnapshotName(int cnt) {
        return (cnt < 10 ? "0000" : "000") + cnt;
    }

    public void getSnapshotUrl(String uid, Video video, VideoWrapper wrapper) {
        int cnt = 1;
        if (StringTools.isNotEmptyAndBlank((String)uid)) {
            cnt = uid.hashCode() % video.getSnapshotCnt();
        }
        String tempUrl = video.getSnapshotUrl().replace("{Count}", this.getSnapshotName(cnt));
        wrapper.setSnapshotUrl(AliyunBean.getScreenshotUrl(tempUrl));
    }

    public void getVideoUrl(String uid, Video video, VideoWrapper wrapper) {
        AliyunConfig aliyunConfig = AliyunBean.getMediaAliyunConfig();
        ArrayList urls = Lists.newArrayList((Object[])new String[]{video.getHd(), video.getNormal(), video.getNormal(), video.getAudit()});
        Map key2Url = OssTools.getInstance((AliyunConfig)aliyunConfig).getUrl((Collection)urls, 3600);
        wrapper.setHd((String)key2Url.get(video.getHd()));
        wrapper.setNormal((String)key2Url.get(video.getNormal()));
        wrapper.setLow((String)key2Url.get(video.getLow()));
        wrapper.setAudit((String)key2Url.get(video.getAudit()));
    }
}

