/*
 * Decompiled with CFR 0.152.
 */
package com.jz.jar.media.proxy;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.jz.common.utils.collection.ArrayMapTools;
import com.jz.common.utils.text.StringTools;
import com.jz.jar.media.service.TopicService;
import com.jz.jooq.media.tables.pojos.Topic;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class TopicProxy {
    private static final Map<String, Topic> id2Topic = Maps.newHashMap();
    private static final Map<String, List<Topic>> parent2Children = Maps.newHashMap();
    @Autowired
    private TopicService topicService;

    public void loadTopicCache() {
        List topics = this.topicService.find();
        if (ArrayMapTools.isEmpty((Collection)topics)) {
            return;
        }
        for (Topic it : topics) {
            id2Topic.put(it.getId(), it);
            if (StringTools.isEmptyAndBlank((String)it.getParent())) continue;
            if (!parent2Children.containsKey(it.getParent())) {
                parent2Children.put(it.getParent(), Lists.newArrayList());
            }
            parent2Children.get(it.getParent()).add(it);
        }
    }

    public Map<String, Topic> getTopics(Collection<String> topicIds) {
        if (ArrayMapTools.isEmpty(topicIds)) {
            return Maps.newHashMap();
        }
        HashMap tempResult = Maps.newHashMap();
        Sets.newHashSet(topicIds).forEach(it -> {
            if (!id2Topic.containsKey(it)) {
                return;
            }
            tempResult.put(it, id2Topic.get(it));
        });
        return tempResult;
    }
}

