/*
 * Decompiled with CFR 0.152.
 */
package com.jz.jar.media.proxy;

import com.google.common.collect.Lists;
import com.jz.common.utils.collection.ArrayMapTools;
import com.jz.jar.media.service.PlaylistService;
import com.jz.jar.media.service.UserCollectService;
import com.jz.jar.media.tool.AliyunBean;
import com.jz.jar.media.wrapper.PlaylistWrapper;
import com.jz.jooq.media.tables.pojos.Playlist;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class PlaylistProxy {
    @Autowired
    private PlaylistService playlistService;
    @Autowired
    private UserCollectService userCollectService;

    public PlaylistWrapper getPlaylist(String pid, String uid) {
        Playlist pl = this.playlistService.getPlaylist(pid);
        if (null == pl) {
            return null;
        }
        PlaylistWrapper wp = PlaylistWrapper.of(pl).setThumnail(AliyunBean.getScreenshotUrl(pl.getThumnail()));
        wp.setIsCollect(this.userCollectService.isCollect(uid, pid));
        return wp;
    }

    public List<PlaylistWrapper> getPlaylist(Collection<String> pids, String uid, Boolean isCollect) {
        List playlistArray = this.playlistService.getPlaylist(pids);
        if (ArrayMapTools.isEmpty((Collection)playlistArray)) {
            return null;
        }
        List collectPlaylist = null;
        if (null == isCollect && null == (collectPlaylist = this.userCollectService.getExistCollect(uid, pids))) {
            collectPlaylist = Lists.newArrayList();
        }
        ArrayList wrappers = Lists.newArrayList();
        PlaylistWrapper wp = null;
        for (Playlist pl : playlistArray) {
            wp = PlaylistWrapper.of(pl).setThumnail(AliyunBean.getScreenshotUrl(pl.getThumnail()));
            wp.setIsCollect(null != collectPlaylist ? collectPlaylist.contains(pl.getId()) : isCollect.booleanValue());
            wrappers.add(wp);
        }
        return wrappers;
    }
}

