package com.jz.jar.media.wrapper;

import com.jz.jooq.media.tables.pojos.Playlist;

/**
 * @Title PlaylistWrapper
 * @Package com.jz.playabc.api.wrapper
 * @author tangjunfeng
 * @date 2018年8月2日 下午12:17:11
 * @version V1.0
 */
public class PlaylistWrapper {
	private PlaylistWrapper() {
	}

	private String id;
	private String name;
	private String thumnail;
	private String description;
	private Integer videoCnt;

	// 是否收藏
	private Boolean isCollect;

	public static PlaylistWrapper of(Playlist playlist) {
		return new PlaylistWrapper().setId(playlist.getId()).setName(playlist.getName())
				.setThumnail(playlist.getThumnail()).setDescription(playlist.getDescription())
				.setVideoCnt(playlist.getVideoCnt());
	}

	public String getId() {
		return id;
	}

	public PlaylistWrapper setId(String id) {
		this.id = id;
		return this;
	}

	public String getName() {
		return name;
	}

	public PlaylistWrapper setName(String name) {
		this.name = name;
		return this;
	}

	public String getThumnail() {
		return thumnail;
	}

	public PlaylistWrapper setThumnail(String thumnail) {
		this.thumnail = thumnail;
		return this;
	}

	public String getDescription() {
		return description;
	}

	public PlaylistWrapper setDescription(String description) {
		this.description = description;
		return this;
	}

	public Integer getVideoCnt() {
		return videoCnt;
	}

	public PlaylistWrapper setVideoCnt(Integer videoCnt) {
		this.videoCnt = videoCnt;
		return this;
	}

	public Boolean getIsCollect() {
		return isCollect;
	}

	public PlaylistWrapper setIsCollect(Boolean isCollect) {
		this.isCollect = isCollect;
		return this;
	}

}
