package com.jz.jar.media.proxy;

import java.util.Collection;
import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import com.google.common.collect.Lists;
import com.jz.common.utils.collection.ArrayMapTools;
import com.jz.jar.media.service.PlaylistService;
import com.jz.jar.media.service.UserCollectService;
import com.jz.jar.media.tool.AliyunBean;
import com.jz.jar.media.wrapper.PlaylistWrapper;
import com.jz.jooq.media.tables.pojos.Playlist;

@Component
public class PlaylistProxy {

	@Autowired
	private PlaylistService playlistService;
	@Autowired
	private UserCollectService userCollectService;

	public PlaylistWrapper getPlaylist(String pid, String uid) {
		Playlist pl = playlistService.getPlaylist(pid);
		if (null == pl)
			return null;
		PlaylistWrapper wp = PlaylistWrapper.of(pl).setThumnail(AliyunBean.getScreenshotUrl(pl.getThumnail()));
		wp.setIsCollect(userCollectService.isCollect(uid, pid));
		return wp;
	}

	public List<PlaylistWrapper> getPlaylist(Collection<String> pids, String uid, Boolean isCollect) {
		List<Playlist> playlistArray = playlistService.getPlaylist(pids);
		if (ArrayMapTools.isEmpty(playlistArray))
			return null;
		List<String> collectPlaylist = null;
		if (null == isCollect) { // 获取已经收藏的专辑
			collectPlaylist = userCollectService.getExistCollect(uid, pids);
			if (null == collectPlaylist)
				collectPlaylist = Lists.newArrayList();
		}
		List<PlaylistWrapper> wrappers = Lists.newArrayList();
		PlaylistWrapper wp = null;
		for (Playlist pl : playlistArray) {
			wp = PlaylistWrapper.of(pl).setThumnail(AliyunBean.getScreenshotUrl(pl.getThumnail()));
			wp.setIsCollect(null != collectPlaylist ? collectPlaylist.contains(pl.getId()) : isCollect);
			wrappers.add(wp);
		}
		return wrappers;
	}
}
