package com.jz.jar.media.wrapper;

import com.jz.jooq.media.tables.pojos.QuestionOption;

/**
 * @Title QuestionOptionWrapper
 * @Package com.jz.jar.media.wrapper
 * @author tangjunfeng
 * @date 2018年9月4日 下午4:37:18
 * @version V1.0
 */
public class QuestionOptionWrapper {
	private QuestionOptionWrapper() {
	}

	private String qid;
	private String oid;
	private Boolean isRight;
	private String pic;
	private String character;

	public static QuestionOptionWrapper of() {
		return new QuestionOptionWrapper();
	}

	public static QuestionOptionWrapper of(QuestionOption option) {
		return of().setQid(option.getQid()).setOid(option.getOid()).setPic(option.getPic())
				.setCharacter(option.getCharacter()).setIsRight(option.getIsRight() == 1);
	}

	public String getQid() {
		return qid;
	}

	public QuestionOptionWrapper setQid(String qid) {
		this.qid = qid;
		return this;
	}

	public String getOid() {
		return oid;
	}

	public QuestionOptionWrapper setOid(String oid) {
		this.oid = oid;
		return this;
	}

	public Boolean getIsRight() {
		return isRight;
	}

	public QuestionOptionWrapper setIsRight(Boolean isRight) {
		this.isRight = isRight;
		return this;
	}

	public String getPic() {
		return pic;
	}

	public QuestionOptionWrapper setPic(String pic) {
		this.pic = pic;
		return this;
	}

	public String getCharacter() {
		return character;
	}

	public QuestionOptionWrapper setCharacter(String character) {
		this.character = character;
		return this;
	}

}
