package com.jz.live.repository;

import java.util.Collection;
import java.util.List;

import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Repository;

import com.jz.jooq.live.Tables;
import com.jz.jooq.live.tables.pojos.LiveInfo;

@Lazy
@Repository
public class LiveInfoRepository extends LiveBaseRepository {

	private static final com.jz.jooq.live.tables.LiveInfo LI = Tables.LIVE_INFO;

	public List<LiveInfo> mutiGetLiveInfo(Collection<String> lids) {
		return liveCtx.selectFrom(LI).where(LI.LID.in(lids)).fetchInto(LiveInfo.class);
	}

	public LiveInfo getLiveInfo(String lid) {
		return liveCtx.selectFrom(LI).where(LI.LID.eq(lid)).fetchAnyInto(LiveInfo.class);
	}
}
