package com.jz.live.repository;

import java.util.Collection;
import java.util.List;

import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Repository;

import com.jz.jooq.live.Tables;

/**
 * @author 连杰
 */
@Lazy
@Repository
public class LiveJoinableSchoolLevelRepository extends LiveBaseRepository {

	private static final com.jz.jooq.live.tables.LiveJoinableSchoolLevel LJSL = Tables.LIVE_JOINABLE_SCHOOL_LEVEL;

	public boolean checkJoinAble(String lid, Collection<String> filterSchoolIds, Collection<Integer> filterCourseIds) {
		return liveCtx.fetchExists(LJSL,
				LJSL.LID.eq(lid).and(LJSL.SCHOOL_ID.in(filterSchoolIds)).and(LJSL.COURSE_ID.in(filterCourseIds)));
	}

	public Collection<String> getLidsForStudent(List<String> filterSchoolIds, List<Integer> levels) {
		return liveCtx.select(LJSL.LID).from(LJSL)
				.where(LJSL.SCHOOL_ID.in(filterSchoolIds).and(LJSL.COURSE_ID.in(levels))).fetchInto(String.class);
	}
}
