package com.jz.live.repository;

import java.util.Collection;
import java.util.List;

import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Repository;

import com.jz.jooq.live.Tables;

/**
 * @author 连杰
 */
@Lazy
@Repository
public class LiveVideoRepository extends LiveBaseRepository {

	private static final com.jz.jooq.live.tables.LiveVideo LV = Tables.LIVE_VIDEO;

	public List<String> mutiGetHaveReplayLids(Collection<String> lids) {
		return liveCtx.select(LV.STREAM).from(LV).where(LV.STREAM.in(lids).and(LV.STATUS.eq(1))).groupBy(LV.STREAM)
				.fetchInto(String.class);
	}

}
