package com.jz.live.repository;

import java.util.List;

import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Repository;

import com.jz.jooq.live.Tables;
import com.jz.jooq.live.tables.pojos.LiveProduct;

@Lazy
@Repository
public class LiveProductRepository extends LiveBaseRepository {

	private static final com.jz.jooq.live.tables.LiveProduct LP = Tables.LIVE_PRODUCT;

	public List<String> getPidsByProduct(String lid) {
		return liveCtx.select(LP.PID).from(LP).where(LP.LID.eq(lid)).orderBy(LP.CREATE_TIME.desc())
				.fetchInto(String.class);
	}

	public void onlineProduct(String lid, String pid) {
		liveCtx.insertInto(LP, LP.LID, LP.PID, LP.CREATE_TIME).values(lid, pid, System.currentTimeMillis())
				.onDuplicateKeyIgnore().execute();
	}

	public void offlineProduct(String lid, String pid) {
		liveCtx.deleteFrom(LP).where(LP.LID.eq(lid).and(LP.PID.eq(pid))).execute();
	}

	public List<String> getLidsByPid(String pid) {
		return liveCtx.select(LP.LID).from(LP).where(LP.PID.eq(pid)).fetchInto(String.class);
	}

	public LiveProduct getLiveProduct(String lid, String pid) {
		return liveCtx.selectFrom(LP).where(LP.LID.eq(lid).and(LP.PID.eq(pid))).fetchAnyInto(LiveProduct.class);
	}

	public void setWindowProduct(String lid, String pid) {
		liveCtx.update(LP).set(LP.IS_WINDOW, 0).where(LP.LID.eq(lid)).execute();
		liveCtx.update(LP).set(LP.IS_WINDOW, 1).where(LP.LID.eq(lid).and(LP.PID.eq(pid))).execute();
	}

	public void cancelWindowProduct(String lid, String pid) {
		liveCtx.update(LP).set(LP.IS_WINDOW, 0).where(LP.LID.eq(lid).and(LP.PID.eq(pid))).execute();
	}

	public LiveProduct getLiveWindowProduct(String lid) {
		return liveCtx.selectFrom(LP).where(LP.LID.eq(lid).and(LP.IS_WINDOW.eq(1))).fetchAnyInto(LiveProduct.class);
	}

	public Boolean checkIsWindow(String lid, String pid) {
		return liveCtx.fetchExists(LP, LP.LID.eq(lid).and(LP.PID.eq(pid)).and(LP.IS_WINDOW.eq(1)));
	}
}
