/*
 * Decompiled with CFR 0.152.
 */
package com.jz.live.repository;

import com.jz.jooq.live.Tables;
import com.jz.jooq.live.tables.LiveProduct;
import com.jz.live.repository.LiveBaseRepository;
import java.util.List;
import org.jooq.Condition;
import org.jooq.Field;
import org.jooq.SelectField;
import org.jooq.Table;
import org.jooq.TableLike;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Repository;

@Lazy
@Repository
public class LiveProductRepository
extends LiveBaseRepository {
    private static final LiveProduct LP = Tables.LIVE_PRODUCT;

    public List<String> getPidsByProduct(String lid) {
        return this.liveCtx.select((SelectField)LiveProductRepository.LP.PID).from((TableLike)LP).where(new Condition[]{LiveProductRepository.LP.LID.eq((Object)lid)}).orderBy(LiveProductRepository.LP.CREATE_TIME.desc()).fetchInto(String.class);
    }

    public void onlineProduct(String lid, String pid) {
        this.liveCtx.insertInto((Table)LP, (Field)LiveProductRepository.LP.LID, (Field)LiveProductRepository.LP.PID, (Field)LiveProductRepository.LP.CREATE_TIME).values((Object)lid, (Object)pid, (Object)System.currentTimeMillis()).onDuplicateKeyIgnore().execute();
    }

    public void offlineProduct(String lid, String pid) {
        this.liveCtx.deleteFrom((Table)LP).where(new Condition[]{LiveProductRepository.LP.LID.eq((Object)lid).and(LiveProductRepository.LP.PID.eq((Object)pid))}).execute();
    }

    public List<String> getLidsByPid(String pid) {
        return this.liveCtx.select((SelectField)LiveProductRepository.LP.LID).from((TableLike)LP).where(new Condition[]{LiveProductRepository.LP.PID.eq((Object)pid)}).fetchInto(String.class);
    }
}

