package com.jz.gymchina.jar.resources.repository;

import java.util.Collection;
import java.util.List;

import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Repository;

import com.jz.jooq.gymchina.resources.Tables;
import com.jz.jooq.gymchina.resources.tables.pojos.GroupInfo;

@Lazy
@Repository
public class GroupInfoRepository extends ResourceBaseRepository {

	private static com.jz.jooq.gymchina.resources.tables.GroupInfo GI = Tables.GROUP_INFO;

	public void refreshGroupInfo(String gid, String name) {
		resourcesCtx.insertInto(GI, GI.GID, GI.NAME).values(gid, name).onDuplicateKeyUpdate().set(GI.NAME, name)
				.execute();
	}

	public GroupInfo getGroupInfo(String gid) {
		return resourcesCtx.selectFrom(GI).where(GI.GID.eq(gid)).fetchAnyInto(GroupInfo.class);
	}

	public List<GroupInfo> getGroups() {
		return resourcesCtx.selectFrom(GI).orderBy(GI.SEQ.asc()).fetchInto(GroupInfo.class);
	}

	public List<GroupInfo> getGroups(Collection<String> gids) {
		return resourcesCtx.selectFrom(GI).where(GI.GID.in(gids)).orderBy(GI.SEQ.asc()).fetchInto(GroupInfo.class);
	}

	public int countGroups(Collection<String> gids) {
		return resourcesCtx.fetchCount(GI, GI.GID.in(gids));
	}

	public List<String> getGroupIdsForUgid(String ugid) {
		return resourcesCtx.select(GI.GID).from(GI).where(GI.UGID.eq(ugid)).fetchInto(String.class);
	}
}
